/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.caller;

import de.duehl.basics.caller.NiceStackTraceElement;
import de.duehl.basics.collections.CollectionsHelper;
import java.util.ArrayList;
import java.util.List;

public class CallerDeterminer {
    private static final int INDEX_WE_WANT = 5;

    public static List<NiceStackTraceElement> getStacktraceElements() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        ArrayList<NiceStackTraceElement> arrayList = new ArrayList<NiceStackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            NiceStackTraceElement niceStackTraceElement = new NiceStackTraceElement(stackTraceElement);
            arrayList.add(niceStackTraceElement);
        }
        return arrayList;
    }

    public static Class<?> determineCallingClass() {
        NiceStackTraceElement niceStackTraceElement = CallerDeterminer.getCallerElement(0);
        return niceStackTraceElement.getClassObject();
    }

    public static Class<?> determineCallingClass(int n) {
        NiceStackTraceElement niceStackTraceElement = CallerDeterminer.getCallerElement(n);
        return niceStackTraceElement.getClassObject();
    }

    public static String determineCallingClassName() {
        NiceStackTraceElement niceStackTraceElement = CallerDeterminer.getCallerElement(0);
        return niceStackTraceElement.getClassName();
    }

    private static NiceStackTraceElement getCallerElement(int n) {
        List<NiceStackTraceElement> list = CallerDeterminer.getStacktraceElements();
        if (list.size() < 5 + n) {
            throw new RuntimeException("Die Liste der Stack-Trace-Elemente ist nicht gro\u00df genug!\n\telements = " + CollectionsHelper.listListNice(list));
        }
        NiceStackTraceElement niceStackTraceElement = list.get(5 + n);
        return niceStackTraceElement;
    }

    public static String determineCallingMethodName() {
        NiceStackTraceElement niceStackTraceElement = CallerDeterminer.getCallerElement(0);
        return niceStackTraceElement.getMethodName();
    }
}

