/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.date.DateHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.TimeHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Timestamp {
    public static final Pattern STANDARD_TIMESTAMP_PATTERN = Pattern.compile("\\d{8}_\\d{6}");
    public static final String STANDARD_DELIMITER = "_";

    private Timestamp() {
    }

    public static String fullTimestamp() {
        return Timestamp.fullTimestamp(STANDARD_DELIMITER);
    }

    public static String fullTimestamp(String string) {
        DateAndTime dateAndTime = new DateAndTime();
        ImmutualTime immutualTime = dateAndTime.getTime();
        String string2 = immutualTime.asHhMmSs();
        ImmutualDate immutualDate = dateAndTime.getDate();
        String string3 = immutualDate.asYyyyMmDd();
        return string3 + string + string2;
    }

    public static String actualDate() {
        return DateHelper.actualDateAsString();
    }

    public static String actualTime() {
        return TimeHelper.actualTimeAsString();
    }

    public static String actualDateAndTime(String string) {
        DateAndTime dateAndTime = new DateAndTime();
        ImmutualTime immutualTime = dateAndTime.getTime();
        String string2 = immutualTime.toString();
        ImmutualDate immutualDate = dateAndTime.getDate();
        String string3 = immutualDate.toString();
        return string3 + string + string2;
    }

    public static int compareTimestamps(String string, String string2) {
        return string.compareTo(string2);
    }

    public static boolean firstTimestampIsNewer(String string, String string2) {
        return string.compareTo(string2) > 0;
    }

    public static boolean firstTimestampIsOlder(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    public static String switchDateTimePartInName(String string, String string2) {
        Matcher matcher = STANDARD_TIMESTAMP_PATTERN.matcher(string);
        if (matcher.find()) {
            String string3 = string.substring(0, matcher.start());
            String string4 = string.substring(matcher.end(), string.length());
            return string3 + string2 + string4;
        }
        throw new RuntimeException("Es wurde kein Timestamp-Part im Format JJJJMMTT_HHMMSS im Dateinamen '" + string + "' gefunden!");
    }

    public static String switchDateTimePartInName(String string) {
        return Timestamp.switchDateTimePartInName(string, Timestamp.fullTimestamp());
    }

    public static String beautifyTimestamp(String string) {
        if (string.matches("\\d{8}_\\d{6}")) {
            String string2 = string.substring(0, 4);
            String string3 = string.substring(4, 6);
            String string4 = string.substring(6, 8);
            String string5 = string.substring(9, 11);
            String string6 = string.substring(11, 13);
            String string7 = string.substring(13, 15);
            return string4 + "." + string3 + "." + string2 + ", " + string5 + ":" + string6 + ":" + string7;
        }
        return string;
    }

    public static String beautifiedTimestampToFullTimestamp(String string) {
        if (string.matches("\\d{2}\\.\\d{2}\\.\\d{4}, \\d{2}:\\d{2}:\\d{2}")) {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = string.substring(6, 10);
            String string5 = string.substring(12, 14);
            String string6 = string.substring(15, 17);
            String string7 = string.substring(18, 20);
            return string4 + string3 + string2 + STANDARD_DELIMITER + string5 + string6 + string7;
        }
        return string;
    }

    public static ImmutualDate getDateFromTimestamp(String string) {
        if (!string.matches("\\d{8}_\\d{6}.*")) {
            throw new IllegalArgumentException("Parameter timestamp ist nicht im passenden Format.\n\ttimestamp = " + string);
        }
        String string2 = string.substring(0, 8);
        return new ImmutualDate(string2);
    }

    public static ImmutualTime getTimeFromTimestamp(String string) {
        if (!string.matches("\\d{8}_\\d{6}.*")) {
            throw new IllegalArgumentException("Parameter timestamp ist nicht im passenden Format.\n\ttimestamp = " + string);
        }
        String string2 = string.substring(9, 11);
        String string3 = string.substring(11, 13);
        String string4 = string.substring(13, 15);
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        int n3 = Integer.parseInt(string4);
        return new ImmutualTime(n, n2, n3);
    }

    public static DateAndTime getDateAndTimeFromTimestamp(String string) {
        ImmutualDate immutualDate = Timestamp.getDateFromTimestamp(string);
        ImmutualTime immutualTime = Timestamp.getTimeFromTimestamp(string);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public static boolean isTimestamp(String string) {
        Matcher matcher = STANDARD_TIMESTAMP_PATTERN.matcher(string);
        return matcher.matches();
    }
}

