/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.data;

import de.duehl.basics.datetime.DateAndTime;
import java.util.Objects;

public class DateAndTimeString {
    private final String date;
    private final String time;

    public DateAndTimeString(String string, String string2) {
        this.date = string;
        this.time = string2;
        DateAndTimeString.checkDate(string);
        DateAndTimeString.checkTime(string2);
    }

    public DateAndTimeString(DateAndTime dateAndTime) {
        this(dateAndTime.getDate().toString(), dateAndTime.getTime().toString());
    }

    public DateAndTimeString() {
        this(new DateAndTime());
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String toString() {
        return "DateAndTimeString [date=" + this.date + ", time=" + this.time + "]";
    }

    public int hashCode() {
        return Objects.hash(this.date, this.time);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateAndTimeString dateAndTimeString = (DateAndTimeString)object;
        return Objects.equals(this.date, dateAndTimeString.date) && Objects.equals(this.time, dateAndTimeString.time);
    }

    public static void checkDate(String string) {
        if (!DateAndTimeString.isDateOk(string)) {
            throw new RuntimeException("Das Datum hat nicht das Format 'DD.MM.YYYY'.\n\tdate = " + string + "\n");
        }
    }

    public static void checkTime(String string) {
        if (!DateAndTimeString.isTimeOk(string)) {
            throw new RuntimeException("Die Uhrzeit hat nicht das Format 'HH:MM:SS'.\n\ttime = " + string + "\n");
        }
    }

    public static boolean isDateOk(String string) {
        return string.matches("\\d{2}\\.\\d{2}\\.\\d{4}");
    }

    public static boolean isTimeOk(String string) {
        return string.matches("\\d{2}:\\d{2}:\\d{2}");
    }
}

