/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time.watch;

import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.basics.datetime.time.watch.WatchBase;
import java.io.Serializable;

public class CountDownWatch
implements WatchBase,
Serializable {
    private static final long serialVersionUID = 1L;
    private long startTime;
    private long duration;

    public CountDownWatch(String string) {
        this(TimeHelper.hoursMinutesSecondsToSeconds(string));
    }

    public CountDownWatch(long l) {
        this.setDurationInSeconds(l);
        this.start();
    }

    public void start() {
        this.startTime = TimeHelper.getCurrentTimeInMilliseconds();
    }

    public void setDurationInMilliseconds(long l) {
        this.duration = l;
    }

    public void setDurationInSeconds(long l) {
        this.setDurationInMilliseconds(l * 1000L);
    }

    @Override
    public String getTime() {
        return TimeHelper.secondsToHoursMinutesSeconds(this.getTimeInSeconds());
    }

    @Override
    public long getTimeInSeconds() {
        return this.getTimeInMilliSeconds() / 1000L;
    }

    long getTimeInMilliSeconds() {
        long l = TimeHelper.getCurrentTimeInMilliseconds();
        long l2 = l - this.startTime;
        if (l2 > this.duration) {
            return 0L;
        }
        return this.duration - l2;
    }

    public String toString() {
        return "CountDownWatch [" + this.getTime() + "]";
    }
}

