/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.history;

import de.duehl.basics.history.HistoryObjectCopier;
import java.util.ArrayList;
import java.util.List;

public class History<T> {
    private static final boolean DEBUG = false;
    private int index;
    private final List<T> list;
    private HistoryObjectCopier<T> copier;

    public History(HistoryObjectCopier<T> historyObjectCopier) {
        this.copier = historyObjectCopier;
        this.index = -1;
        this.list = new ArrayList<T>();
    }

    public void add(T t) {
        this.say("Start");
        T t2 = this.copier.copy(t);
        if (this.list.isEmpty()) {
            this.list.add(t2);
            this.index = 0;
        } else if (this.index == this.list.size() - 1) {
            this.list.add(t2);
            ++this.index;
        } else {
            for (int i = this.list.size() - 1; i > this.index; --i) {
                this.list.remove(i);
            }
            this.list.add(t2);
            ++this.index;
        }
        this.say("Ende");
    }

    public void checkActual(T t) {
        if (!t.equals(this.list.get(this.index))) {
            throw new RuntimeException("Logischer Fehler mit der Historie! Es wurde vergessen, \u00c4nderungen mitzuteilen, das aktuelle Objekt weicht ab!");
        }
    }

    public boolean hasPrevious() {
        boolean bl = !this.list.isEmpty() && this.index > 0;
        this.say(bl ? "ja" : "nein");
        return bl;
    }

    public boolean hasNext() {
        boolean bl = !this.list.isEmpty() && this.index + 1 < this.list.size();
        this.say(bl ? "ja" : "nein");
        return bl;
    }

    public T getPrevious() {
        this.say("Start");
        if (!this.hasPrevious()) {
            throw new RuntimeException("Es gibt keine fr\u00fchere Version!");
        }
        --this.index;
        T t = this.list.get(this.index);
        T t2 = this.copier.copy(t);
        this.say("Ende");
        return t2;
    }

    public T getNext() {
        this.say("Start");
        if (!this.hasNext()) {
            throw new RuntimeException("Es gibt keine sp\u00e4tere Version!");
        }
        ++this.index;
        T t = this.list.get(this.index);
        T t2 = this.copier.copy(t);
        this.say("Ende");
        return t2;
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.index = -1;
        this.list.clear();
    }

    private void say(String string) {
    }
}

