/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.zip;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.PrintErrorHandler;
import de.duehl.basics.system.starter.CmdStarter;
import java.util.ArrayList;
import java.util.List;

public class UnzipWith7Zip {
    private final String pathTo7Zip;
    private List<String> createdFilenames;
    private boolean useZipFileDirForCreatedFiles;
    private String dirForCreatedFiles;
    private boolean cypher;
    private String password;
    private String command;

    public UnzipWith7Zip() {
        this("\\\\Cluster1\\Projekte1\\HRTag\\HR_Strukt_HuP\\CD\\auslieferung\\bin\\7z\\7za.exe");
    }

    public UnzipWith7Zip(String string) {
        this.pathTo7Zip = string;
        this.createdFilenames = new ArrayList<String>();
        this.useZipFileDirForCreatedFiles = true;
        this.cypher = false;
        this.command = "";
    }

    public void cypher(String string) {
        if (string.contains(" ")) {
            throw new IllegalArgumentException("Das Passwort darf keine Leerzeichen beinhalten, weil sonst die Verwendung auf der Kommandozeile nicht wie gew\u00fcnscht funktioniert.");
        }
        this.cypher = true;
        this.password = string;
    }

    public void setDirForCreatedFiles(String string) {
        this.useZipFileDirForCreatedFiles = false;
        this.dirForCreatedFiles = string;
    }

    public void unzip(String string, String string2) {
        if (string.contains(" ")) {
            throw new IllegalArgumentException("Der Dateiname des Archivs darf keine Leerzeichen beinhalten, weil sonst die Verwendung auf der Kommandozeile nicht wie gew\u00fcnscht funktioniert.");
        }
        if (string2.contains(" ")) {
            throw new IllegalArgumentException("Das Zielverzeichnis darf keine Leerzeichen beinhalten, weil sonst die Verwendung auf der Kommandozeile nicht wie gew\u00fcnscht funktioniert.");
        }
        Object object = this.cypher ? "-p" + this.password + " " : "";
        this.command = this.pathTo7Zip + " x " + (String)object + string + " -o" + string2;
        CmdStarter cmdStarter = new CmdStarter(new PrintErrorHandler());
        if (this.useZipFileDirForCreatedFiles) {
            this.dirForCreatedFiles = FileHelper.getDirName(string);
        }
        String string3 = FileHelper.getBareName(string);
        String string4 = "unzip_" + FileHelper.exchangeExtension(string3, ".txt");
        String string5 = "unzip_" + FileHelper.exchangeExtension(string3, ".err");
        String string6 = FileHelper.concatPathes(this.dirForCreatedFiles, string4);
        String string7 = FileHelper.concatPathes(this.dirForCreatedFiles, string5);
        cmdStarter.runAndWait(this.command, string6, string7);
        this.createdFilenames.add(string6);
        this.createdFilenames.add(string7);
    }

    public List<String> getCreatedFilenames() {
        return this.createdFilenames;
    }

    public String getCommand() {
        return this.command;
    }
}

