/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logic;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineArguments {
    private final List<String> flagOptions;
    private final Map<String, String> valueOptions;
    private final List<String> parameters;
    private final String commandLine;

    public CommandLineArguments(String[] stringArray) {
        this(Arrays.asList(stringArray));
    }

    public CommandLineArguments(List<String> list) {
        this.commandLine = this.buildCommandLine(list);
        this.flagOptions = CommandLineArguments.analyseFlagOptions(list);
        this.valueOptions = CommandLineArguments.analyseValueOptions(list);
        this.parameters = CommandLineArguments.analyseParameters(list);
    }

    private String buildCommandLine(List<String> list) {
        return Text.join(" ", list);
    }

    private static List<String> analyseFlagOptions(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if ("--".equals(string)) break;
            if (!string.startsWith("--") || string.contains("=")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Map<String, String> analyseValueOptions(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            if ("--".equals(string)) break;
            if (!string.startsWith("--") || !string.contains("=")) continue;
            int n = string.indexOf("=");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static List<String> analyseParameters(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string : list) {
            if ("--".equals(string)) {
                bl = true;
                continue;
            }
            if (!bl && string.startsWith("--")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean hasFlagOption(String string) {
        return this.flagOptions.contains(string);
    }

    public boolean hasFlagOptions() {
        return !this.flagOptions.isEmpty();
    }

    public boolean hasValueOption(String string) {
        return this.valueOptions.containsKey(string);
    }

    public boolean hasValueOptions() {
        return !this.valueOptions.isEmpty();
    }

    public String getValueOption(String string) {
        return this.valueOptions.get(string);
    }

    public String getParameter(int n) {
        return this.parameters.get(n);
    }

    public int getNumberOfFlagOptions() {
        return this.flagOptions.size();
    }

    public int getNumberOfValueOptions() {
        return this.valueOptions.size();
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public boolean numberOfParameterIs(int n) {
        return n == this.getNumberOfParameters();
    }

    public boolean numberOfFlagOptionsIs(int n) {
        return n == this.getNumberOfFlagOptions();
    }

    public boolean numberOfValueOptionsIs(int n) {
        return n == this.getNumberOfValueOptions();
    }

    public boolean haveNoParameters() {
        return this.numberOfParameterIs(0);
    }

    public boolean haveNoFlagOptions() {
        return this.numberOfFlagOptionsIs(0);
    }

    public boolean haveNoValueOptions() {
        return this.numberOfValueOptionsIs(0);
    }

    public boolean haveHelpOption() {
        return this.hasFlagOption("--help") || this.hasParameter("-h") || this.hasParameter("/?");
    }

    private boolean hasParameter(String string) {
        return this.parameters.contains(string);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    Optionen ohne zugeordnete Werte:\n");
        for (String object : this.flagOptions) {
            stringBuilder.append("        ");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        stringBuilder.append("    Optionen mit zugeordneten Werten:\n");
        for (String string : CollectionsHelper.getSortedMapStringIndices(this.valueOptions)) {
            stringBuilder.append("        ");
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(this.valueOptions.get(string));
            stringBuilder.append("\n");
        }
        stringBuilder.append("    Parameter:\n");
        int n = 0;
        for (String string : this.parameters) {
            stringBuilder.append("        ");
            stringBuilder.append(Integer.toString(n++));
            stringBuilder.append(") ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getCommandLine() {
        return this.commandLine;
    }
}

