/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.proccess;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.exceptions.IORuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class ExternalProcess {
    private final String[] parameters;
    private Process process;
    private boolean inheritIO = false;

    public ExternalProcess(List<String> list) {
        this(CollectionsHelper.stringListToArray(list));
    }

    public ExternalProcess(String ... stringArray) {
        this.parameters = stringArray;
    }

    public void inheritIO() {
        this.inheritIO = true;
    }

    public void runWaitAndHandleErrors() {
        this.start();
        this.waitForProcess();
        this.handleErrors();
    }

    private void start() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.parameters);
            if (this.inheritIO) {
                processBuilder.inheritIO();
            }
            this.process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private void waitForProcess() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IORuntimeException("Das Warten auf den Process wurde unterbrochen. Parameter des Prozesses: " + CollectionsHelper.stringArrayToString(this.parameters), interruptedException);
        }
    }

    private void handleErrors() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (stringBuilder.length() > 0) {
            throw new RuntimeException("Fehler beim Ausf\u00fchren des Programms.\nParameter des Prozesses: " + CollectionsHelper.stringArrayToString(this.parameters) + "\nAufgetretene Fehler:\n\t" + stringBuilder.toString());
        }
    }
}

