/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexCompiler {
    private final String regex;
    private Pattern pattern;
    private boolean compilationSuccessfull;
    private PatternSyntaxException compileException;

    public RegexCompiler(String string) {
        this.regex = string;
    }

    public void compile() {
        try {
            this.pattern = Pattern.compile(this.regex);
            this.compilationSuccessfull = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.compileException = patternSyntaxException;
            this.compilationSuccessfull = false;
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isCompilationSuccessfull() {
        return this.compilationSuccessfull;
    }

    public PatternSyntaxException getCompileException() {
        return this.compileException;
    }

    public String toString() {
        return "RegexCompiler [regex=" + this.regex + ", compilationSuccessfull=" + this.compilationSuccessfull + "]";
    }
}

