/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.system.OperationSystem;
import de.duehl.basics.text.Text;
import java.awt.Desktop;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;

public class SystemTools {
    private static final List<String> WINDOWS_PROGRAM_DIRECTORYS = CollectionsHelper.buildListFrom(SystemTools.toLowerNormalisedPath("C:\\Program Files"), SystemTools.toLowerNormalisedPath("C:\\Program Files (x86)"), SystemTools.toLowerNormalisedPath("C:\\Programme"), SystemTools.toLowerNormalisedPath("C:\\Programme (x86)"));

    public static OperationSystem determineOperationSystem() {
        String string = System.getProperty("os.name", "unknown system");
        OperationSystem operationSystem = OperationSystem.UNKNOWN;
        if ("Mac OS X".equals(string)) {
            operationSystem = OperationSystem.OSX;
        } else if (string.startsWith("Windows")) {
            operationSystem = OperationSystem.WINDOWS;
        }
        return operationSystem;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepSeconds(long l) {
        SystemTools.sleep(1000L * l);
    }

    public static void sleepMinutes(long l) {
        SystemTools.sleepSeconds(60L * l);
    }

    public static void setOutToCp850() {
        try {
            System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, "CP850"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public static String getUserName() {
        String string = System.getProperty("user.name", "").toLowerCase();
        return string;
    }

    public static String getComputerName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    public static String getHomeDirectory() {
        String string = System.getProperty("user.home", ".");
        return string;
    }

    public static String getLocalhost() {
        try {
            return SystemTools.tryGetLocalhost();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String tryGetLocalhost() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostAddress();
        return string;
    }

    public static void openInBrowser(String string) {
        if (!Desktop.isDesktopSupported()) {
            throw new RuntimeException("Desktop wird nicht supported!");
        }
        Desktop desktop = Desktop.getDesktop();
        SystemTools.openInBrowser(desktop, string);
    }

    private static void openInBrowser(Desktop desktop, String string) {
        try {
            SystemTools.tryToOpenInBrowser(desktop, string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es gab ein Problem beim \u00d6ffnen der URL '" + string + ":", exception);
        }
    }

    private static void tryToOpenInBrowser(Desktop desktop, String string) throws MalformedURLException, IOException, URISyntaxException {
        desktop.browse(new URL(string).toURI());
    }

    public static void openInStandardProgram(String string) {
        if (!Desktop.isDesktopSupported()) {
            throw new RuntimeException("Desktop wird nicht supported!");
        }
        Desktop desktop = Desktop.getDesktop();
        SystemTools.openInStandardProgram(desktop, string);
    }

    private static void openInStandardProgram(Desktop desktop, String string) {
        try {
            desktop.open(new File(string));
        }
        catch (Exception exception) {
            throw new RuntimeException("Es gab ein Problem beim \u00d6ffnen der Datei '" + string + ":", exception);
        }
    }

    public static String determineRunningJavaExecutable() {
        try {
            return SystemTools.tryToDetermineRunningJavaExecutable();
        }
        catch (Exception exception) {
            throw new RuntimeException("Das aktuelle Arbeitsverzeichnis kann nicht ermeittel werden: " + exception.getMessage(), exception);
        }
    }

    private static String tryToDetermineRunningJavaExecutable() {
        String string = ProcessHandle.current().info().command().orElseThrow();
        return string;
    }

    public static String getCurrentWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    private static String toLowerNormalisedPath(String string) {
        return Text.toLowerCase(FileHelper.normalizeToBackSlahes(FileHelper.normalisePath(string)));
    }

    public static boolean isPathInProtectedWindowsProgramDirs(String string) {
        String string2 = SystemTools.toLowerNormalisedPath(string);
        for (String string3 : WINDOWS_PROGRAM_DIRECTORYS) {
            if (!string2.startsWith(string3)) continue;
            return true;
        }
        return false;
    }
}

