/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import java.util.List;

public class HtmlDatasetDescriptionGenerator {
    private final List<String> titles;
    private final List<String> values;
    private final int size;
    private SwingHtmlBuilder html;

    private HtmlDatasetDescriptionGenerator(List<String> list, List<String> list2) {
        this.titles = list;
        this.values = list2;
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Die beiden \u00fcbergebenen Listen mit den \u00dcberschriften und den Werten haben unterschiedliche Gr\u00f6\u00dfen!\n\ttitles.size() = " + list.size() + "\n\tvalues.size() = " + list2.size() + "\n");
        }
        this.size = list.size();
    }

    public String generateHtmlDatasetDescription() {
        this.html = new SwingHtmlBuilder();
        this.html.appendHtml5HeadWithOwnCss("Beschreibung des aktuellen Datensatzes");
        this.html.appendOpeningTableWithBorderWidth(2);
        this.appendTableHeader();
        this.appendTableBody();
        this.html.appendFoot();
        return this.html.toString();
    }

    private void appendTableHeader() {
        this.html.appendOpeningThead();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Feldname");
        this.html.appendLeftAlignedTh("Beschreibung");
        this.html.appendClosingTr();
        this.html.appendClosingThead();
    }

    private void appendTableBody() {
        this.html.appendOpeningTbody();
        for (int i = 0; i < this.size; ++i) {
            String string = this.titles.get(i);
            String string2 = this.values.get(i);
            string2 = HtmlTool.encodeHtmlAmpLtAndGt(string2);
            this.appendTableBodyRow(string, string2);
        }
        this.html.appendClosingTbody();
    }

    private void appendTableBodyRow(String string, String string2) {
        this.html.appendOpeningTr();
        this.html.appendTd(string);
        this.html.appendTd(string2);
        this.html.appendClosingTr();
    }

    public static String generateHtmlDatasetDescription(List<String> list, List<String> list2) {
        HtmlDatasetDescriptionGenerator htmlDatasetDescriptionGenerator = new HtmlDatasetDescriptionGenerator(list, list2);
        return htmlDatasetDescriptionGenerator.generateHtmlDatasetDescription();
    }
}

