/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class MultiLineTagJoiner {
    private final List<String> lines;
    private final String tag;
    private final String openingTag1;
    private final String openingTag2;
    private final String closingTag;
    private final List<String> alternativEnds;
    private boolean replacing;

    public MultiLineTagJoiner(List<String> list, String string) {
        this.lines = list;
        this.tag = string;
        this.openingTag1 = "<" + string + " ";
        this.openingTag2 = "<" + string + ">";
        this.closingTag = "</" + string + ">";
        this.alternativEnds = new ArrayList<String>();
    }

    public void addAlternativEnd(String string) {
        this.alternativEnds.add(string);
    }

    public void join() {
        this.replacing = true;
        while (this.replacing) {
            this.replaceLoop();
        }
    }

    private void replaceLoop() {
        this.replacing = false;
        int n = this.determineIndexOfLineWithOpeningAndNotClosingTag();
        if (n == -1) {
            return;
        }
        int n2 = this.determineIndexOfLineWithClosingTag(n);
        if (n2 == -1) {
            throw new RuntimeException("Nach einer Zeile mit einem \u00f6ffnenden " + this.tag + "-Tag wurde keine mit dem schlie\u00dfenden " + this.tag + "-Tag gefunden.\nZeilen:\n" + CollectionsHelper.listListNice(this.lines));
        }
        this.joinZTitleLines(n, n2);
        this.replacing = true;
    }

    private int determineIndexOfLineWithOpeningAndNotClosingTag() {
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = this.lines.get(i);
            String string2 = string.strip();
            if (!string2.startsWith(this.openingTag1) && !string2.startsWith(this.openingTag2) || this.strippedLineEndsWithTag(string2)) continue;
            return i;
        }
        return -1;
    }

    private boolean strippedLineEndsWithTag(String string) {
        if (string.endsWith(this.closingTag)) {
            return true;
        }
        for (String string2 : this.alternativEnds) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private int determineIndexOfLineWithClosingTag(int n) {
        int n2 = n;
        boolean bl = true;
        while (bl) {
            if (++n2 >= this.lines.size()) {
                bl = false;
                return -1;
            }
            String string = this.lines.get(n2);
            String string2 = string.strip();
            if (!string2.endsWith(this.closingTag)) continue;
            bl = false;
        }
        return n2;
    }

    private void joinZTitleLines(int n, int n2) {
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.lines.get(n);
        String string2 = string.strip();
        int n4 = Text.findIndexOfFirstNonSpace(string);
        String string3 = Text.multipleString(" ", n4);
        arrayList.add(string3 + string2);
        for (n3 = n + 1; n3 <= n2; ++n3) {
            String string4 = this.lines.get(n3);
            String string5 = string4.strip();
            arrayList.add(string5);
        }
        for (n3 = n2; n3 >= n; --n3) {
            this.lines.remove(n3);
        }
        String string6 = Text.joinWithBlank(arrayList);
        this.lines.add(n, string6);
    }
}

