/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download;

import de.duehl.basics.debug.Assure;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.text.NumberString;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadParameters;
import de.duehl.html.download.data.RedirectHandling;
import de.duehl.html.download.logic.InternalDownloader;
import de.duehl.html.download.proxy.Proxy;
import de.duehl.html.download.proxy.RotatingProxies;
import java.util.List;

public class Downloader {
    private final DownloadParameters parameters;

    public Downloader(String string) {
        Assure.notEmpty("Die URL 'website'", string);
        this.parameters = new DownloadParameters(string);
    }

    public Downloader setLogger(Logger logger) {
        this.parameters.setLogger(logger);
        this.log("Verwende Logger");
        return this;
    }

    public Downloader useProxy(Proxy proxy) {
        this.parameters.setProxy(proxy);
        this.parameters.setUseProxy(true);
        this.parameters.setUseRotatingProxies(false);
        this.log("Verwende Proxy: " + proxy);
        return this;
    }

    public Downloader useRotatingProxies(List<Proxy> list) {
        this.parameters.setRotatingProxies(new RotatingProxies(list));
        this.parameters.setUseProxy(true);
        this.parameters.setUseRotatingProxies(true);
        this.log("Verwende rotierende Proxies: " + list);
        return this;
    }

    public Downloader useLaxRedirectHandling() {
        this.parameters.setRedirectHandling(RedirectHandling.LAX);
        this.log("Verwende laxe Strategie zum Umgang mit Redirects.");
        return this;
    }

    public Downloader useStandardRedirectHandling() {
        this.parameters.setRedirectHandling(RedirectHandling.STANDARD);
        this.log("Verwende Standard-Strategie zum Umgang mit Redirects.");
        return this;
    }

    public Downloader disableRedirectHandling() {
        this.parameters.setRedirectHandling(RedirectHandling.NONE);
        this.log("Folge keinen Redirects.");
        return this;
    }

    public Downloader multipleDownloadTries(int n, long l) {
        Assure.isPositive(n);
        Assure.isPositive(l);
        this.parameters.setMaximumNumberOfTries(n);
        this.parameters.setSecondsToSleep(l);
        this.log("Verwende mehrere Versuche, die Webseite herunterzuladen. Anzahl Versuche : " + NumberString.taupu(n) + ", Wartezeit zwischen Versuchen: " + NumberString.taupu(l) + " Sekunden.");
        return this;
    }

    public Downloader cancelAfter(int n, long l) {
        this.parameters.setUseTimedThreadRunner(true);
        this.parameters.setSecondsBeforeKill(n);
        this.parameters.setMillisecondsBetweenWatching(l);
        this.log("Der einzelne Download wird abgebrochen, wenn er zu lange braucht. Sekunden bis zum Abbruch : " + NumberString.taupu(n) + ", Wartezeit zwischen den \u00dcberpr\u00fcfungen: " + NumberString.taupu(l) + " Millisekunden.");
        return this;
    }

    public DownloadInfo download() {
        InternalDownloader internalDownloader = new InternalDownloader(this.parameters);
        return internalDownloader.download();
    }

    private void log(String string) {
        if (this.parameters.weHaveALogger()) {
            Logger logger = this.parameters.getLogger();
            logger.log(string, 1);
        }
    }
}

