/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.mp3.player;

import de.duehl.basics.system.SystemTools;
import de.duehl.mp3.player.VolumeCalculations;
import de.duehl.mp3.player.data.MusicEndReachedReactor;
import de.duehl.mp3.player.javazoom.MoreAdvancedPlayer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.JavaSoundAudioDevice;

public class MP3Player {
    private static final boolean DEBUG = false;
    private String filename;
    private MoreAdvancedPlayer player = null;
    private AudioDevice device;
    private FloatControl volumeControl;
    private List<MusicEndReachedReactor> musicEndReachedReactors = new ArrayList<MusicEndReachedReactor>();

    public void addMusicEndReachedReactor(MusicEndReachedReactor musicEndReachedReactor) {
        this.musicEndReachedReactors.add(musicEndReachedReactor);
    }

    public void removeMusicEndReachedReactor(MusicEndReachedReactor musicEndReachedReactor) {
        this.musicEndReachedReactors.remove(musicEndReachedReactor);
    }

    public void playMP3InOwnThread(String string) {
        this.playMP3InOwnThread(string, 0);
    }

    public void playMP3InOwnThread(String string, int n) {
        this.filename = string;
        this.startPlayInOwnThread(n);
    }

    private void startPlayInOwnThread(int n) {
        try {
            this.tryToStartPlayInOwnThread(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es gab ein Problem bei startPlayInOwnThread().", exception);
        }
    }

    private void tryToStartPlayInOwnThread(int n) {
        this.preparePlayer();
        new Thread(() -> this.startPlay(n)).start();
    }

    private void preparePlayer() {
        try {
            InputStream inputStream = this.createInputStream();
            this.device = this.createAudioDevice();
            this.player = new MoreAdvancedPlayer(inputStream, this.device);
        }
        catch (Exception exception) {
            this.killPlayer();
            throw new RuntimeException("Es gab ein Problem bei preparePlayer().", exception);
        }
    }

    private InputStream createInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.filename));
    }

    private AudioDevice createAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    private void startPlay(int n) {
        try {
            this.tryToStartPlay(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Es gab ein Problem bei startPlay().", exception);
        }
        finally {
            this.killPlayer();
        }
    }

    private void tryToStartPlay(int n) {
        boolean bl = this.player.playFromFrame(n);
        if (!bl) {
            this.informReactors();
        }
    }

    private void informReactors() {
        for (MusicEndReachedReactor musicEndReachedReactor : this.musicEndReachedReactors) {
            musicEndReachedReactor.musicEndReached();
        }
    }

    public void setVolumeInPercent(int n) {
        float f = VolumeCalculations.volumePercentToVolumeDb(n);
        this.say("Setze auf: " + VolumeCalculations.toCorrectVolumePercent(n) + "%, also " + f + " dB");
        this.setVolumeInDb(f);
    }

    public void setVolumeInDb(float f) {
        this.say("setVolume() gain = " + f);
        if (this.volumeControl == null) {
            this.say("War null");
            this.initVolumeControl();
        }
        if (this.volumeControl == null) {
            this.say("Ist immer noch null");
        } else {
            float f2;
            float f3 = this.volumeControl.getMinimum();
            if (Math.abs(f3 - -80.0f) > 0.01f) {
                System.out.println("Abweichung vom erwarteten Lautst\u00e4rke Minimum: " + f3 + " statt -80.0");
            }
            if ((f2 = this.volumeControl.getMaximum()) > 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Math.min(Math.max(f, f3), f2);
            this.say("War: " + this.volumeControl.getValue() + ", wird nun gesetzt auf: " + f4);
            this.volumeControl.setValue(f4);
        }
    }

    private void initVolumeControl() {
        try {
            this.tryToInitVolumeControl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void tryToInitVolumeControl() throws IllegalArgumentException, IllegalAccessException {
        Class<JavaSoundAudioDevice> clazz = JavaSoundAudioDevice.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        Line line = null;
        for (Field field : fieldArray) {
            if (!"source".equals(field.getName())) continue;
            field.setAccessible(true);
            while (line == null) {
                SystemTools.sleep(5L);
                line = (SourceDataLine)field.get(this.device);
                if (this.sourceHasMasterGain((SourceDataLine)line)) continue;
                line = null;
            }
            field.setAccessible(false);
            this.volumeControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            break;
        }
    }

    private boolean sourceHasMasterGain(SourceDataLine sourceDataLine) {
        try {
            sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int stop() {
        return this.killPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int killPlayer() {
        MP3Player mP3Player = this;
        synchronized (mP3Player) {
            if (this.player == null) {
                return -1;
            }
            this.player.stop();
            this.player.flush();
            int n = this.player.getLastPlayedFrame();
            this.player = null;
            return n;
        }
    }

    private void say(String string) {
    }
}

