/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.mp3.unused;

import de.duehl.basics.system.SystemTools;
import de.duehl.mp3.player.VolumeCalculations;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.JavaSoundAudioDevice;
import javazoom.jl.player.advanced.AdvancedPlayer;

public class MP3PlayerAlt {
    private static final boolean DEBUG = false;
    private String filename;
    private AdvancedPlayer player = null;
    private AudioDevice device;
    private FloatControl volumeControl;

    public void playMP3InOwnThread(String string) {
        this.filename = string;
        this.startPlayInOwnThread();
    }

    private void startPlayInOwnThread() {
        try {
            this.tryToStartPlayInOwnThread();
        }
        catch (Exception exception) {
            this.reportProblem();
        }
    }

    private void tryToStartPlayInOwnThread() {
        this.preparePlayer();
        new Thread(() -> this.startPlay()).start();
    }

    private void preparePlayer() {
        try {
            InputStream inputStream = this.createInputStream();
            this.device = this.createAudioDevice();
            this.player = new AdvancedPlayer(inputStream, this.device);
        }
        catch (IOException iOException) {
            this.reportProblem();
            this.killPlayer();
        }
        catch (JavaLayerException javaLayerException) {
            this.reportProblem();
            this.killPlayer();
        }
    }

    private InputStream createInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.filename));
    }

    private AudioDevice createAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }

    private void startPlay() {
        try {
            this.player.play();
        }
        catch (JavaLayerException javaLayerException) {
            this.reportProblem();
        }
        finally {
            this.killPlayer();
        }
    }

    public void setVolumeInPercent(int n) {
        float f = VolumeCalculations.volumePercentToVolumeDb(n);
        this.say("Setze auf: " + VolumeCalculations.toCorrectVolumePercent(n) + "%, also " + f + " dB");
        this.setVolumeInDb(f);
    }

    public void setVolumeInDb(float f) {
        this.say("setVolume() gain = " + f);
        if (this.volumeControl == null) {
            this.say("War null");
            this.initVolumeControl();
        }
        if (this.volumeControl == null) {
            this.say("Ist immer noch null");
        } else {
            float f2;
            float f3 = this.volumeControl.getMinimum();
            if (Math.abs(f3 - -80.0f) > 0.01f) {
                System.out.println("Abweichung vom erwarteten Lautst\u00e4rke Minimum: " + f3 + " statt -80.0");
            }
            if (Math.abs((f2 = this.volumeControl.getMaximum()) - 0.0f) > 0.01f) {
                System.out.println("Abweichung vom erwarteten Lautst\u00e4rke Maximum: " + f2 + " statt 0.0");
            }
            float f4 = Math.min(Math.max(f, f3), f2);
            this.say("War: " + this.volumeControl.getValue() + ", wird nun gesetzt auf: " + f4);
            this.volumeControl.setValue(f4);
        }
    }

    private void initVolumeControl() {
        try {
            this.tryToInitVolumeControl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void tryToInitVolumeControl() throws IllegalArgumentException, IllegalAccessException {
        Class<JavaSoundAudioDevice> clazz = JavaSoundAudioDevice.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        Line line = null;
        for (Field field : fieldArray) {
            if (!"source".equals(field.getName())) continue;
            field.setAccessible(true);
            while (line == null) {
                SystemTools.sleep(5L);
                line = (SourceDataLine)field.get(this.device);
                if (this.sourceHasMasterGain((SourceDataLine)line)) continue;
                line = null;
            }
            field.setAccessible(false);
            this.volumeControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            break;
        }
    }

    private boolean sourceHasMasterGain(SourceDataLine sourceDataLine) {
        try {
            sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void stop() {
        this.killPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killPlayer() {
        MP3PlayerAlt mP3PlayerAlt = this;
        synchronized (mP3PlayerAlt) {
            if (this.player != null) {
                this.player.stop();
                this.player = null;
            }
        }
    }

    private void reportProblem() {
        System.out.println("Es gab ein Problem beim Abspielen von: " + this.filename);
    }

    private void say(String string) {
    }
}

