/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.data;

import de.duehl.basics.datetime.date.Weekday;
import de.duehl.swing.data.DailyWeeklyNotType;
import de.duehl.swing.data.MinuteHour;

public class DailyWeeklyNot {
    private DailyWeeklyNotType type = DailyWeeklyNotType.DAILY;
    private MinuteHour dailyTime = new MinuteHour("05:00");
    private Weekday weeklyWeekday = Weekday.SUNDAY;
    private MinuteHour weeklyTime = new MinuteHour("19:00");

    public boolean isDaily() {
        return this.type == DailyWeeklyNotType.DAILY;
    }

    public boolean isWeekly() {
        return this.type == DailyWeeklyNotType.WEEKLY;
    }

    public boolean isNot() {
        return this.type == DailyWeeklyNotType.NOT;
    }

    public DailyWeeklyNotType getType() {
        return this.type;
    }

    public MinuteHour getDailyTime() {
        return this.dailyTime;
    }

    public Weekday getWeeklyWeekday() {
        return this.weeklyWeekday;
    }

    public String getWeeklyWeekdayAsGermanName() {
        return this.getWeeklyWeekday().getGermanName();
    }

    public MinuteHour getWeeklyTime() {
        return this.weeklyTime;
    }

    public void setDaily() {
        this.type = DailyWeeklyNotType.DAILY;
    }

    public void setWeekly() {
        this.type = DailyWeeklyNotType.WEEKLY;
    }

    public void setNot() {
        this.type = DailyWeeklyNotType.NOT;
    }

    public void setType(DailyWeeklyNotType dailyWeeklyNotType) {
        this.type = dailyWeeklyNotType;
    }

    public void setDailyTime(MinuteHour minuteHour) {
        this.dailyTime = minuteHour;
    }

    public void setWeeklyWeekday(Weekday weekday) {
        this.weeklyWeekday = weekday;
    }

    public void setWeeklyWeekdayAsGermanName(String string) {
        this.weeklyWeekday = Weekday.determineByGermanName(string);
    }

    public void setWeeklyTime(MinuteHour minuteHour) {
        this.weeklyTime = minuteHour;
    }

    public String getOneLineDescription() {
        switch (this.type) {
            case DAILY: {
                return "t\u00e4glich um " + this.dailyTime + " Uhr";
            }
            case WEEKLY: {
                return "w\u00f6chentlich am " + this.weeklyWeekday.getGermanName() + " um " + this.weeklyTime + " Uhr";
            }
            case NOT: {
                return "keine";
            }
        }
        throw new RuntimeException("unbekannter Typ " + this.type);
    }

    public String toString() {
        return "DailyWeeklyNot [type=" + this.type + ", dailyTime=" + this.dailyTime + ", weeklyWeekday=" + this.weeklyWeekday + ", weeklyTime=" + this.weeklyTime + "]";
    }
}

