/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.basics.version.Version;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.dialogs.PasswordDialog;
import de.duehl.swing.ui.dialogs.logging.LogfileDialog;
import de.duehl.swing.ui.dialogs.values.ComboBoxDialog;
import de.duehl.swing.ui.dialogs.values.EnterLongTextDialog;
import de.duehl.swing.ui.dragndrop.TextFieldDropTargetListener;
import de.duehl.swing.ui.highlightingeditor.textcomponent.NotEditableScrollingSuppressingTextPane;
import de.duehl.swing.ui.key.KeyDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.plaf.nimbus.AbstractRegionPainter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;

public class GuiTools {
    private static final int DEFAULT_TITLED_BORDER_FONT_SIZE = 12;
    private static final boolean LIMIT_MINIMUM_THUMB_SIZE = true;

    private GuiTools() {
    }

    public static void setNiceLayoutManager() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            UIDefaults uIDefaults = lookAndFeel.getDefaults();
            uIDefaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void respectTextPaneBackgroundInNimbusLookAndFeel(JTextPane jTextPane) {
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            jTextPane.repaint();
            jTextPane.validate();
            jTextPane.revalidate();
            SwingUtilities.invokeLater(() -> {
                Color color = jTextPane.getSelectedTextColor();
                Color color2 = jTextPane.getSelectionColor();
                BasicEditorPaneUI basicEditorPaneUI = new BasicEditorPaneUI();
                jTextPane.setUI(basicEditorPaneUI);
                jTextPane.setSelectedTextColor(color);
                jTextPane.setSelectionColor(color2);
            });
        }
    }

    public static void setHighlightingViewerBackgroundForNimbusLookAndFeel(final Color color) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        uIDefaults.put("TextPane[Enabled].backgroundPainter", new AbstractRegionPainter(){

            @Override
            protected AbstractRegionPainter.PaintContext getPaintContext() {
                return new AbstractRegionPainter.PaintContext(null, null, false);
            }

            @Override
            protected void doPaint(Graphics2D graphics2D, JComponent jComponent, int n, int n2, Object[] objectArray) {
                Color color2 = null != jComponent && jComponent instanceof NotEditableScrollingSuppressingTextPane ? color : Color.WHITE;
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, n, n2);
            }
        });
    }

    public static void biggerFont(Component component, int n) {
        Font font = component.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
        component.setFont(font2);
    }

    public static void smalerFont(Component component, int n) {
        GuiTools.biggerFont(component, -n);
    }

    public static void boldFont(Component component) {
        Font font = component.getFont();
        Font font2 = new Font(font.getFontName(), 1, font.getSize());
        component.setFont(font2);
    }

    public static void normalFont(Component component) {
        Font font = component.getFont();
        Font font2 = new Font(font.getFontName(), 0, font.getSize());
        component.setFont(font2);
    }

    public static void createTitle(JComponent jComponent) {
        GuiTools.createTitle("", jComponent);
    }

    public static void createTitle(String string, JComponent jComponent) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jComponent.setBorder(titledBorder);
    }

    public static void createTitledBorder(String string, JPanel jPanel) {
        GuiTools.createTitledBorder(string, jPanel, new JLabel().getForeground());
    }

    public static void createTitledBorder(String string, JPanel jPanel, Color color) {
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color), string, 1, 0, new JTextField().getFont(), color));
    }

    public static void createBlueTitle(String string, JPanel jPanel) {
        GuiTools.createTitle(string, jPanel, Color.BLUE);
    }

    public static void createTitle(String string, JPanel jPanel, Color color) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleColor(color);
        jPanel.setBorder(titledBorder);
    }

    public static void waitcursorOn(Component component) {
        SwingUtilities.invokeLater(() -> component.setCursor(Cursor.getPredefinedCursor(3)));
    }

    public static void waitcursorOff(Component component) {
        SwingUtilities.invokeLater(() -> component.setCursor(Cursor.getPredefinedCursor(0)));
    }

    public static void waitcursorImmediatelyOn(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void makeTableHeadersLeftAligned(JTable jTable) {
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)jTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
    }

    public static void disableKeys(List<KeyDefinition> list, InputMap ... inputMapArray) {
        for (KeyDefinition keyDefinition : list) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyDefinition.getKeyCode(), keyDefinition.getModifiers());
            for (InputMap inputMap : inputMapArray) {
                inputMap.put(keyStroke, "none");
            }
        }
    }

    public static String openFile(String string, FileFilter fileFilter) {
        return GuiTools.openFile(null, "", string, fileFilter);
    }

    public static String openFile(File file, FileFilter fileFilter) {
        return GuiTools.openFile(null, "", file, fileFilter);
    }

    public static String openFile(String string, String string2, FileFilter fileFilter) {
        return GuiTools.openFile(null, string, new File(string2), fileFilter);
    }

    public static String openFile(String string, File file, FileFilter fileFilter) {
        return GuiTools.openFile(null, string, file, fileFilter);
    }

    public static String openFile(Component component, String string, FileFilter fileFilter) {
        return GuiTools.openFile(component, "", string, fileFilter);
    }

    public static String openFile(Component component, File file, FileFilter fileFilter) {
        return GuiTools.openFile(component, "", file, fileFilter);
    }

    public static String openFile(Component component, String string, String string2, FileFilter fileFilter) {
        return GuiTools.openFile(component, string, new File(string2), fileFilter);
    }

    public static String openFile(Component component, String string, File file, FileFilter fileFilter) {
        int n;
        JFileChooser jFileChooser = GuiTools.createFileChooser(file, fileFilter);
        if (string != null && !string.isEmpty()) {
            jFileChooser.setDialogTitle(string);
        }
        if ((n = jFileChooser.showOpenDialog(component)) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            return file2.getPath();
        }
        return "";
    }

    public static String openFileWithExtension(Component component, String string) {
        String string2 = SystemTools.getHomeDirectory();
        return GuiTools.openFileWithExtension(component, string, string2);
    }

    public static String openFileWithExtension(String string, String string2) {
        return GuiTools.openFileWithExtension(string, new File(string2));
    }

    public static String openFileWithExtension(String string, File file) {
        return GuiTools.openFileWithExtension(null, string, file);
    }

    public static String openFileWithExtension(Component component, String string, String string2) {
        return GuiTools.openFileWithExtension(component, string, new File(string2));
    }

    public static String openFileWithExtension(String string, String string2, String string3) {
        return GuiTools.openFileWithExtension(null, string, string2, new File(string3));
    }

    public static String openFileWithExtension(Component component, String string, String string2, String string3) {
        return GuiTools.openFileWithExtension(component, string, string2, new File(string3));
    }

    public static String openFileWithExtension(Component component, String string, File file) {
        FileFilter fileFilter = GuiTools.createExtensionFileFilter(string);
        return GuiTools.openFile(component, file, fileFilter);
    }

    public static String openFileWithExtension(Component component, String string, String string2, File file) {
        FileFilter fileFilter = GuiTools.createExtensionFileFilter(string2);
        return GuiTools.openFile(component, string, file, fileFilter);
    }

    public static String saveFileAs(String string, FileFilter fileFilter) {
        return GuiTools.saveFileAsWithTitle(null, string, fileFilter);
    }

    public static String saveFileAs(Component component, String string, FileFilter fileFilter) {
        return GuiTools.saveFileAs(component, new File(string), fileFilter);
    }

    public static String saveFileAs(Component component, File file, FileFilter fileFilter) {
        JFileChooser jFileChooser = GuiTools.createFileChooser(file, fileFilter);
        return GuiTools.saveAsWithFileChooser(component, jFileChooser);
    }

    public static String saveFileAsWithTitle(String string, String string2, FileFilter fileFilter) {
        return GuiTools.saveFileAsWithTitle(string, null, string2, fileFilter);
    }

    public static String saveFileAsWithTitle(String string, File file, FileFilter fileFilter) {
        return GuiTools.saveFileAsWithTitle(string, null, file, fileFilter);
    }

    public static String saveFileAsWithTitle(String string, Component component, String string2, FileFilter fileFilter) {
        return GuiTools.saveFileAsWithTitle(string, component, new File(string2), fileFilter);
    }

    public static String saveFileAsWithTitle(String string, Component component, File file, FileFilter fileFilter) {
        JFileChooser jFileChooser = GuiTools.createFileChooser(file, fileFilter);
        jFileChooser.setDialogTitle(string);
        return GuiTools.saveAsWithFileChooser(component, jFileChooser);
    }

    public static String saveFileAsWithTitle(String string, Component component, String string2, FileFilter fileFilter, String string3) {
        return GuiTools.saveFileAsWithTitle(string, component, new File(string2), fileFilter, new File(FileHelper.concatPathes(string2, string3)));
    }

    public static String saveFileAsWithTitle(String string, Component component, File file, FileFilter fileFilter, File file2) {
        JFileChooser jFileChooser = GuiTools.createFileChooser(file, fileFilter);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setSelectedFile(file2);
        return GuiTools.saveAsWithFileChooser(component, jFileChooser);
    }

    private static String saveAsWithFileChooser(Component component, JFileChooser jFileChooser) {
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getPath();
        }
        return "";
    }

    private static JFileChooser createFileChooser(File file, FileFilter fileFilter) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.addHierarchyListener(hierarchyEvent -> GuiTools.requestFocusForTextField(jFileChooser));
        return jFileChooser;
    }

    public static void requestFocusForTextField(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.requestFocusInWindow();
                break;
            }
            if (!(component instanceof JPanel)) continue;
            JPanel jPanel = (JPanel)component;
            GuiTools.requestFocusForTextField(jPanel);
        }
    }

    public static String openDirectory() {
        return GuiTools.openDirectory(null, "", null);
    }

    public static String openDirectory(String string) {
        return GuiTools.openDirectory(string, "", null);
    }

    public static String openDirectory(String string, Component component) {
        return GuiTools.openDirectory(string, "", component);
    }

    public static String openDirectory(String string, String string2) {
        return GuiTools.openDirectory(string, string2, null);
    }

    public static String openDirectory(String string, String string2, Component component) {
        JFileChooser jFileChooser = GuiTools.createDirectoryChooser(string, string2);
        return GuiTools.openDirectoryInternal(jFileChooser, component);
    }

    private static String openDirectoryInternal(JFileChooser jFileChooser, Component component) {
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getAbsolutePath();
        }
        return "";
    }

    public static String saveDirectory(String string, Component component) {
        return GuiTools.saveDirectory(string, "", component);
    }

    public static String saveDirectory(String string, String string2, Component component) {
        JFileChooser jFileChooser = GuiTools.createDirectoryChooser(string, string2);
        return GuiTools.saveDirectoryInternal(jFileChooser, component);
    }

    private static String saveDirectoryInternal(JFileChooser jFileChooser, Component component) {
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getAbsolutePath();
        }
        return "";
    }

    public static String saveDirectory(String string) {
        Component component = null;
        return GuiTools.saveDirectory(string, component);
    }

    public static JFileChooser createDirectoryChooser(String string) {
        return GuiTools.createDirectoryChooser(string, "");
    }

    public static JFileChooser createDirectoryChooser(String string, String string2) {
        JFileChooser jFileChooser = null == string || string.isEmpty() ? new JFileChooser() : new JFileChooser(string);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter fileFilter = GuiTools.createDirectoryFilter();
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileSelectionMode(1);
        if (string2 != null && !string2.isEmpty()) {
            jFileChooser.setDialogTitle(string2);
        }
        return jFileChooser;
    }

    public static FileFilter createDirectoryFilter() {
        return new FileFilter(){

            @Override
            public String getDescription() {
                return "Verzeichnisse";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    public static FileFilter createTextFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public String getDescription() {
                return "Textdateien";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".txt");
            }
        };
        return fileFilter;
    }

    public static FileFilter createLockFileFilter() {
        return new FileFilter(){

            @Override
            public String getDescription() {
                return "Lock-Dateien";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".lock");
            }
        };
    }

    public static FileFilter createTextAndCsvFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".txt") || file.isFile() && file.getName().toLowerCase().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "txt- und csv-Dateien";
            }
        };
    }

    public static FileFilter createExecutableFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString().endsWith(".exe") || file.toString().endsWith(".com") || file.toString().endsWith(".bat") || file.toString().endsWith(".cmd");
            }

            @Override
            public String getDescription() {
                return "Ausf\u00fchrbare Dateien";
            }
        };
    }

    public static FileFilter createExtensionFileFilter(final String string) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (null == file) {
                    return false;
                }
                return file.isDirectory() || file.toString().endsWith(string);
            }

            @Override
            public String getDescription() {
                return "Dateien im " + string + "-Format";
            }
        };
    }

    public static FileFilter createAllFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }

            @Override
            public String getDescription() {
                return "Alle Dateien";
            }
        };
    }

    public static boolean askUserToQuit(Component component) {
        String string = "M\u00f6chten Sie das Programm wirklich beenden?";
        return GuiTools.askUserToQuit(component, string);
    }

    public static boolean askUserToQuit(Component component, String string) {
        Object[] objectArray = new String[]{"Programm beenden", "Weiter machen"};
        int n = JOptionPane.showOptionDialog(component, string, "Programm beenden?", 0, 3, null, objectArray, objectArray[0]);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = false;
        }
        return bl;
    }

    public static boolean askUser(String string, String string2) {
        return GuiTools.askUser(null, string, string2);
    }

    public static boolean askUser(Component component, String string, String string2) {
        Object[] objectArray = new String[]{"Ja", "Nein"};
        int n = JOptionPane.showOptionDialog(component, string2, string, 0, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        return false;
    }

    public static boolean askUserDefaultNo(Component component, String string, String string2) {
        Object[] objectArray = new String[]{"Ja", "Nein"};
        int n = JOptionPane.showOptionDialog(component, string2, string, 0, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        return false;
    }

    public static int askUserWithMultipleAnswers(Component component, String string, String string2, List<String> list, int n) {
        Object[] objectArray = CollectionsHelper.stringListToArray(list);
        int n2 = JOptionPane.showOptionDialog(component, string2, string, -1, 3, null, objectArray, objectArray[n]);
        return n2;
    }

    public static int askUserWithMultipleAnswers(Component component, String string, String string2, List<String> list) {
        Object[] objectArray = CollectionsHelper.stringListToArray(list);
        int n = JOptionPane.showOptionDialog(component, string2, string, -1, 3, null, objectArray, null);
        return n;
    }

    public static void informUserInEdt(String string, String string2) {
        GuiTools.informUserInEdt(null, string, string2);
    }

    public static void informUser(String string, String string2) {
        GuiTools.informUser(null, string, string2);
    }

    public static void informUserInEdt(Component component, String string, String string2) {
        SwingUtilities.invokeLater(() -> GuiTools.informUser(component, string, string2));
    }

    public static void informUser(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 1);
    }

    public static boolean getConfirmationByUser(String string, String string2) {
        return GuiTools.getConfirmationByUser(null, string, string2);
    }

    public static boolean getConfirmationByUser(Component component, String string, String string2) {
        int n = JOptionPane.showConfirmDialog(component, string2, string, 2, 1);
        return n == 0;
    }

    public static String askUserToEnterAStringValue(Component component, String string, String string2) {
        int n = 3;
        String string3 = JOptionPane.showInputDialog(component, string2, string, n);
        if (null == string3) {
            string3 = "";
        }
        return string3.strip();
    }

    public static String askUserToEnterALongStringValue(Component component, String string, String string2) {
        Image image = null;
        String string3 = "";
        return GuiTools.askUserToEnterALongStringValue(component, image, string, string2, string3);
    }

    public static String askUserToEnterALongStringValue(Component component, Image image, String string, String string2) {
        String string3 = "";
        return GuiTools.askUserToEnterALongStringValue(component, image, string, string2, string3);
    }

    public static String askUserToEnterALongStringValue(Component component, Image image, String string, String string2, String string3) {
        EnterLongTextDialog enterLongTextDialog = new EnterLongTextDialog(component.getLocation(), image, string, string2, string3);
        enterLongTextDialog.setVisible(true);
        return enterLongTextDialog.getEnteredValue();
    }

    public static String askUserToEnterAStringValue(String string, String string2) {
        int n = 3;
        String string3 = JOptionPane.showInputDialog(null, string2, string, n);
        if (null == string3) {
            string3 = "";
        }
        return string3;
    }

    public static String askUserToEnterAStringValue(Component component, String string, String string2, String string3) {
        int n = 3;
        String string4 = (String)JOptionPane.showInputDialog(component, string2, string, n, null, null, string3);
        if (null == string4) {
            string4 = "";
        }
        return string4;
    }

    public static String askUserToEnterAStringValue(String string, String string2, String string3) {
        int n = 3;
        String string4 = (String)JOptionPane.showInputDialog(null, string2, string, n, null, null, string3);
        if (null == string4) {
            string4 = "";
        }
        return string4;
    }

    public static String askUserToPickStringFromDropDownOrEnterAValue(Point point, Image image, String string, String string2, String string3, List<String> list) {
        ComboBoxDialog comboBoxDialog = new ComboBoxDialog(point, image, string, string2, string3, list);
        comboBoxDialog.allowEnteringOwnValues();
        comboBoxDialog.setVisible(true);
        return comboBoxDialog.getEnteredValue();
    }

    public static String askUserToPickStringFromDropDown(Point point, Image image, String string, String string2, String string3, List<String> list) {
        ComboBoxDialog comboBoxDialog = new ComboBoxDialog(point, image, string, string2, string3, list);
        comboBoxDialog.setVisible(true);
        return comboBoxDialog.getEnteredValue();
    }

    public static void scrollScrollbarToMinimumLater(JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(() -> GuiTools.scrollScrollbarToMinimum(jScrollPane));
    }

    public static void scrollScrollbarToMaximumLater(JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(() -> GuiTools.scrollScrollbarToMaximum(jScrollPane));
    }

    public static void scrollScrollbarToMinimum(JScrollPane jScrollPane) {
        int n = jScrollPane.getVerticalScrollBar().getMinimum();
        jScrollPane.getVerticalScrollBar().setValue(n);
    }

    public static void scrollScrollbarToMaximum(JScrollPane jScrollPane) {
        int n = jScrollPane.getVerticalScrollBar().getMaximum();
        jScrollPane.getVerticalScrollBar().setValue(n);
    }

    public static void scrollScrollbarToPreviousSectionLater(JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(() -> GuiTools.scrollScrollbarToPreviousSection(jScrollPane));
    }

    public static void scrollScrollbarToNextSectionLater(JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(() -> GuiTools.scrollScrollbarToNextSection(jScrollPane));
    }

    public static void scrollScrollbarToPreviousSection(JScrollPane jScrollPane) {
        int n = jScrollPane.getVerticalScrollBar().getMinimum();
        int n2 = jScrollPane.getVerticalScrollBar().getValue();
        int n3 = jScrollPane.getVisibleRect().height;
        if ((n2 -= n3) < n) {
            n2 = n;
        }
        jScrollPane.getVerticalScrollBar().setValue(n2);
    }

    public static void scrollScrollbarToNextSection(JScrollPane jScrollPane) {
        int n = jScrollPane.getVerticalScrollBar().getValue();
        int n2 = jScrollPane.getVisibleRect().height;
        int n3 = jScrollPane.getVerticalScrollBar().getMaximum();
        if ((n += n2) > n3) {
            n = n3;
        }
        jScrollPane.getVerticalScrollBar().setValue(n);
    }

    public static void addDragNDropTextFieldCorrector(JTextField jTextField, ErrorHandler errorHandler) {
        GuiTools.addDropTargetListenerToTextField(jTextField, errorHandler, new TextFieldDropTargetListener(jTextField));
    }

    public static void addDropTargetListenerToTextField(JTextField jTextField, ErrorHandler errorHandler, DropTargetListener dropTargetListener) {
        try {
            jTextField.getDropTarget().addDropTargetListener(dropTargetListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            errorHandler.error("Fehler beim Registrieren eines DropTargetListeners", tooManyListenersException);
        }
    }

    public static void addDropTargetListenerToTextArea(JTextArea jTextArea, ErrorHandler errorHandler, DropTargetListener dropTargetListener) {
        try {
            jTextArea.getDropTarget().addDropTargetListener(dropTargetListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            errorHandler.error("Fehler beim Registrieren eines DropTargetListeners", tooManyListenersException);
        }
    }

    public static JPanel createBorderLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        return jPanel;
    }

    public static JPanel createBorderLayoutPanelWithTitle() {
        JPanel jPanel = GuiTools.createBorderLayoutPanel();
        GuiTools.createTitle(jPanel);
        return jPanel;
    }

    public static JPanel createBorderLayoutPanelWithTitle(String string) {
        JPanel jPanel = GuiTools.createBorderLayoutPanel();
        GuiTools.createTitle(string, jPanel);
        return jPanel;
    }

    public static JPanel createBorderLayoutPanelWithTitleAndCenterElement(Component component) {
        JPanel jPanel = GuiTools.createBorderLayoutPanelWithTitle();
        jPanel.add(component, "Center");
        return jPanel;
    }

    public static JPanel createBorderLayoutPanelWithTitleAndCenterElement(String string, Component component) {
        JPanel jPanel = GuiTools.createBorderLayoutPanelWithTitle(string);
        jPanel.add(component, "Center");
        return jPanel;
    }

    public static JPanel createFloatingCenteredPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        return jPanel;
    }

    public static JPanel createFloatingLeftPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        return jPanel;
    }

    public static JLabel createVerticalCenteredLabel(String string) {
        JLabel jLabel = new JLabel(string);
        GuiTools.centerLabelVertically(jLabel);
        return jLabel;
    }

    public static void centerLabelVertically(JLabel jLabel) {
        jLabel.setVerticalAlignment(0);
    }

    public static JLabel createBigLabel(String string) {
        JLabel jLabel = new JLabel(string);
        GuiTools.boldFont(jLabel);
        return jLabel;
    }

    public static JLabel createVerticalCenteredBigLabel(String string) {
        JLabel jLabel = GuiTools.createBigLabel(string);
        GuiTools.centerLabelVertically(jLabel);
        return jLabel;
    }

    public static void setEditFieldColors(JTextComponent jTextComponent) {
        jTextComponent.setBackground(Color.WHITE);
        jTextComponent.setForeground(Color.BLACK);
        jTextComponent.setCaretColor(Color.RED);
        GuiTools.setMonospacedFont(jTextComponent);
    }

    public static void setEditAreaColors(JTextArea jTextArea) {
        jTextArea.setBackground(Color.WHITE);
        jTextArea.setForeground(Color.BLACK);
        jTextArea.setCaretColor(Color.RED);
        GuiTools.setMonospacedFont(jTextArea);
    }

    public static void setMonospacedFont(Component component) {
        GuiTools.setMonospacedFont(component, 14);
    }

    public static void setMonospacedFont(Component component, int n) {
        Font font = new Font("Monospaced", 0, n);
        component.setFont(font);
    }

    public static void setFontSize(Component component, int n) {
        Font font = component.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), n);
        component.setFont(font2);
    }

    public static Component surroundWithTitledPanel(Component component, String string) {
        JPanel jPanel = new JPanel();
        GuiTools.createTitle(string, jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "Center");
        return jPanel;
    }

    public static JPanel centerHorizontal(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    public static JPanel centerVertical(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    public static JPanel center(Component component) {
        return GuiTools.centerVertical(GuiTools.centerHorizontal(component));
    }

    public static void showLogFiles(String string) {
        GuiTools.showLogFiles(null, string, null);
    }

    public static void showLogFiles(Component component, String string, Image image) {
        String string2 = GuiTools.openFileWithExtension(component, ".log", string);
        if (!string2.isEmpty()) {
            Point point = null == component ? new Point() : component.getLocation();
            LogfileDialog logfileDialog = GuiTools.createLogFileDialog(string2, point, image);
            logfileDialog.setVisible(true);
        }
    }

    public static LogfileDialog createLogFileDialog(String string, Point point, Image image) {
        LogfileDialog logfileDialog = new LogfileDialog(string, point, image);
        return logfileDialog;
    }

    public static Component toNorth(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "North");
        return jPanel;
    }

    public static Component toEast(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "East");
        return jPanel;
    }

    public static Component toSouth(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "South");
        return jPanel;
    }

    public static Component toWest(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "West");
        return jPanel;
    }

    public static Dimension getScreenSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        return dimension;
    }

    public static int getScreenHeight() {
        Dimension dimension = GuiTools.getScreenSize();
        return dimension.height;
    }

    public static int getScreenWidth() {
        Dimension dimension = GuiTools.getScreenSize();
        return dimension.width;
    }

    public static Icon loadIcon(String string, Class<?> clazz) {
        try {
            BufferedImage bufferedImage = ImageIO.read(clazz.getResource(string));
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void removeF6FromJSplitPane(JSplitPane jSplitPane) {
        GuiTools.removeKeyFormJSplitPane(jSplitPane, 117);
    }

    public static void removeF8FromJSplitPane(JSplitPane jSplitPane) {
        GuiTools.removeKeyFormJSplitPane(jSplitPane, 119);
    }

    private static void removeKeyFormJSplitPane(JSplitPane jSplitPane, int n) {
        jSplitPane.getInputMap(1).put(KeyStroke.getKeyStroke(n, 0), "none");
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void addReturnListener(Component component, Runnable runnable) {
        component.addKeyListener(GuiTools.createReturnKeyListener(runnable));
    }

    public static KeyListener createReturnKeyListener(final Runnable runnable) {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0) {
                    runnable.run();
                }
            }
        };
    }

    public static void setVerticalScrollBarUnitIncrement(JScrollPane jScrollPane, int n) {
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
    }

    public static void setHorizontalScrollBarUnitIncrement(JScrollPane jScrollPane, int n) {
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(n);
    }

    public static JScrollPane createScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        GuiTools.setVerticalScrollBarUnitIncrement(jScrollPane, 30);
        return jScrollPane;
    }

    public static String toVerticalButtonText(String string) {
        return "<html>" + Text.join("<br>", Text.eachCharFromString(string)) + "</html>";
    }

    public static void ignorePageUpAndPageDownInComponent(JComponent jComponent) {
        for (InputMap inputMap : GuiTools.createIgnoreKeysInputMaps(jComponent)) {
            inputMap.put(KeyStroke.getKeyStroke(33, 0), "none");
            inputMap.put(KeyStroke.getKeyStroke(34, 0), "none");
        }
    }

    private static List<InputMap> createIgnoreKeysInputMaps(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        InputMap inputMap2 = jComponent.getInputMap(2);
        InputMap inputMap3 = jComponent.getInputMap(0);
        InputMap inputMap4 = jComponent.getInputMap(1);
        List<InputMap> list = CollectionsHelper.buildListFrom(inputMap, inputMap2, inputMap3, inputMap4);
        return list;
    }

    public static void ignoreUpAndDownInComponent(JComponent jComponent) {
        for (InputMap inputMap : GuiTools.createIgnoreKeysInputMaps(jComponent)) {
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "none");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "none");
        }
    }

    public static void ignoreCtrlPos1AndCtrlEndInComponent(JComponent jComponent) {
        for (InputMap inputMap : GuiTools.createIgnoreKeysInputMaps(jComponent)) {
            inputMap.put(KeyStroke.getKeyStroke(36, 128), "none");
            inputMap.put(KeyStroke.getKeyStroke(35, 128), "none");
        }
    }

    public static void biggerTitledBorderFontOfPanel(JPanel jPanel, int n) {
        Border border = jPanel.getBorder();
        if (null != border && border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            Font font = titledBorder.getTitleFont();
            Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
            titledBorder.setTitleFont(font2);
        }
    }

    public static void defaultTitledBorderFontSize(JPanel jPanel) {
        GuiTools.setTitledBorderFontSize(jPanel, 12);
    }

    public static void setTitledBorderFontSize(JPanel jPanel, int n) {
        Border border = jPanel.getBorder();
        if (null != border && border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            Font font = titledBorder.getTitleFont();
            Font font2 = new Font(font.getName(), font.getStyle(), n);
            titledBorder.setTitleFont(font2);
        }
    }

    public static int getTitledBorderFontSizeOfPanel(JPanel jPanel) {
        Border border = jPanel.getBorder();
        if (null == border) {
            return -1;
        }
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            Font font = titledBorder.getTitleFont();
            return font.getSize();
        }
        return -1;
    }

    public static void setForegroundAndBackground(JButton jButton, Color color) {
        jButton.setBackground(color);
        jButton.setForeground(ColorTool.anticolor(color));
    }

    public static void showAbout(String string, String string2, Version version, ImageIcon imageIcon, JFrame jFrame) {
        GuiTools.showAbout(string, string2, "", version, imageIcon, jFrame);
    }

    public static void showAbout(String string, String string2, String string3, Version version, ImageIcon imageIcon, JFrame jFrame) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "\n\n");
        stringBuilder.append("Autor: Christian D\u00fchl\n");
        if (!string3.isBlank()) {
            stringBuilder.append(string3).append("\n");
        }
        stringBuilder.append("Version: " + version.getVersionAndDate() + "\n\n");
        String string4 = stringBuilder.toString();
        JOptionPane.showMessageDialog(jFrame, string4, "\u00dcber " + string2 + " " + string, 1, imageIcon);
    }

    public static Component indentComponent(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(50, 0));
        jPanel.add((Component)jLabel, "West");
        jPanel.add(component, "Center");
        return jPanel;
    }

    public static void takeScreenshot(Component component, String string) {
        BufferedImage bufferedImage = GuiTools.getScreenShot(component);
        GuiTools.writeImageToFile(bufferedImage, string);
    }

    private static BufferedImage getScreenShot(Component component) {
        BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        component.printAll(bufferedImage.getGraphics());
        return bufferedImage;
    }

    private static void writeImageToFile(BufferedImage bufferedImage, String string) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (Exception exception) {
            throw new RuntimeException("Konnte den Screenshot nicht unter '" + string + "' abspeichern.", exception);
        }
    }

    public static void takeScreenshotWithoutFrame(JFrame jFrame, String string) {
        GuiTools.takeScreenshot(jFrame.getContentPane(), string);
    }

    public static MouseAdapter createSingleClickMouseAdapter(final Runnable runnable) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 1) {
                    runnable.run();
                }
            }
        };
    }

    public static MouseAdapter createDoubleClickMouseAdapter(final Runnable runnable) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    runnable.run();
                }
            }
        };
    }

    public static void createDoubleClickAndDispatchMouseScrollEventMouseAdapter(final Component component, final Runnable runnable) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    runnable.run();
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                component.getParent().dispatchEvent(mouseWheelEvent);
            }
        });
    }

    public static void dispatchMouseScrollEvent(final Component component) {
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                for (Container container = component.getParent(); container != null; container = container.getParent()) {
                    container.dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    public static void dispatchMouseScrollEvent(final Component component, final int n) {
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n2 = 0;
                for (Container container = component.getParent(); container != null && n2 < n; container = container.getParent(), ++n2) {
                    container.dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    public static void dispatchMouseScrollEventOnlyOnce(final Component component) {
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Container container = component.getParent();
                if (container != null) {
                    container.dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    public static JTextField getTextFieldInComboBox(JComboBox<String> jComboBox) {
        return (JTextField)jComboBox.getEditor().getEditorComponent();
    }

    public static String createHtmlTextForButtonsWithUnderscoreReplacement(String string, int n) {
        String string2 = string.replace("_", " ");
        return GuiTools.createHtmlTextForButtons(string2, n);
    }

    public static String createHtmlTextForButtons(String string, int n) {
        Object object = string;
        if (((String)object).length() > n) {
            object = Text.addLineBreaks((String)object, n);
            object = HtmlTool.htmlifyWithoutFrame((String)object);
        }
        object = "<html>" + (String)object + "</html>";
        return object;
    }

    public static Component makeGridLayoutComponentNotYGreedy(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "North");
        jPanel.add((Component)new JLabel(""), "Center");
        return jPanel;
    }

    public static JScrollPane addNotHorizontalScrollingScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component, 20, 31);
        GuiTools.setVerticalScrollBarUnitIncrement(jScrollPane, 30);
        return jScrollPane;
    }

    public static String askUserToEnterAPassword(String string, String string2) {
        PasswordDialog passwordDialog = new PasswordDialog(string, string2);
        passwordDialog.setVisible(true);
        String string3 = passwordDialog.getPassword();
        return string3;
    }

    public static void setFocusTraversalKeysToEmptySet(Component component) {
        Set set = Collections.emptySet();
        Set set2 = Collections.emptySet();
        component.setFocusTraversalKeys(0, set);
        component.setFocusTraversalKeys(1, set2);
    }

    public static Component addLeftSpace(Component component, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, n, 0, 0));
        return jPanel;
    }

    public static Component createEasternComponent(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "East");
        return jPanel;
    }

    public static Component createEmptyLabelWithWith(int n) {
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(n, 0));
        return jLabel;
    }
}

