/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.painted;

import de.duehl.swing.ui.buttons.painted.PaintedButton;
import de.duehl.swing.ui.geometry.PixelPoint;
import java.awt.Color;
import java.util.Random;

public class DiceButton
extends PaintedButton {
    private static final long serialVersionUID = -1L;
    private static final Color BACKGROUND_COLOR = new Color(231, 224, 189);
    private static final Color EYE_COLOR = new Color(28, 28, 28);
    private RollValue rollValue;

    public DiceButton(RollValue rollValue) {
        this.setForceSquare(true);
        this.rollValue = rollValue;
    }

    public void setRollValue(RollValue rollValue) {
        this.rollValue = rollValue;
        this.repaint();
    }

    @Override
    protected void setSymbolColorInGraphics() {
        this.graphics2.setColor(EYE_COLOR);
        if (this.isChangeColorOnMouseOver() && this.getModel().isRollover()) {
            this.graphics2.setColor(Color.RED);
        }
    }

    @Override
    protected void paintHorizontalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintHorizontalSymbolSquare() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolSquare() {
        this.paintSymbol();
    }

    private void paintSymbol() {
        boolean bl;
        boolean bl2;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isForceSquare()) {
            n2 = n = Math.min(n, n2);
        }
        int n3 = Math.max(2, n / 10);
        int n4 = (int)Math.max(5.0, (double)n3 * 1.7);
        int n5 = (this.getWidth() - n) / 2;
        int n6 = n4 + n5;
        int n7 = n5 + n - 1;
        int n8 = n7 - n4;
        int n9 = (this.getHeight() - n2) / 2;
        int n10 = n4 + n9;
        int n11 = n9 + n2 - 1;
        int n12 = n11 - n4;
        int n13 = (n5 + n7) / 2;
        int n14 = (n9 + n11) / 2;
        PixelPoint pixelPoint = new PixelPoint(n6, n10);
        PixelPoint pixelPoint2 = new PixelPoint(n8, n10);
        PixelPoint pixelPoint3 = new PixelPoint(n6, n12);
        PixelPoint pixelPoint4 = new PixelPoint(n8, n12);
        PixelPoint pixelPoint5 = new PixelPoint(n13, n14);
        PixelPoint pixelPoint6 = new PixelPoint(n13, n10);
        PixelPoint pixelPoint7 = new PixelPoint(n13, n12);
        this.graphics2.setColor(BACKGROUND_COLOR);
        this.paintTwoPointRectangle(n5, n9, n7, n11);
        this.setSymbolColorInGraphics();
        boolean bl3 = this.rollValue == RollValue.FOUR || this.rollValue == RollValue.FIVE || this.rollValue == RollValue.SIX;
        boolean bl4 = bl2 = this.rollValue == RollValue.TWO || this.rollValue == RollValue.THREE || this.rollValue == RollValue.FOUR || this.rollValue == RollValue.FIVE || this.rollValue == RollValue.SIX;
        boolean bl5 = bl3;
        boolean bl6 = this.rollValue == RollValue.ONE || this.rollValue == RollValue.THREE || this.rollValue == RollValue.FIVE;
        boolean bl7 = this.rollValue == RollValue.SIX;
        boolean bl8 = bl = this.rollValue == RollValue.SIX;
        if (bl3) {
            this.paintCircle(pixelPoint, n3);
        }
        if (bl2) {
            this.paintCircle(pixelPoint2, n3);
        }
        if (bl4) {
            this.paintCircle(pixelPoint3, n3);
        }
        if (bl5) {
            this.paintCircle(pixelPoint4, n3);
        }
        if (bl6) {
            this.paintCircle(pixelPoint5, n3);
        }
        if (bl7) {
            this.paintCircle(pixelPoint6, n3);
        }
        if (bl) {
            this.paintCircle(pixelPoint7, n3);
        }
    }

    public static enum RollValue {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        NONE;


        public static RollValue selectRandomly() {
            int n = RollValue.values().length;
            int n2 = new Random().nextInt(n);
            return RollValue.values()[n2];
        }

        public static RollValue generateFromInteger(int n) {
            switch (n) {
                case 0: {
                    return ONE;
                }
                case 1: {
                    return TWO;
                }
                case 2: {
                    return THREE;
                }
                case 3: {
                    return FOUR;
                }
                case 4: {
                    return FIVE;
                }
                case 5: {
                    return SIX;
                }
            }
            return NONE;
        }
    }
}

