/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.swing.ui.components.selections.ComboBoxSelection;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import java.awt.Color;

public class SelectionsHelper {
    public static final Color NOT_EDITABLE_FIELD_COLOR = new Color(240, 240, 240);
    public static final Color EDITABLE_FIELD_COLOR = new Color(255, 255, 180);

    public static void initSelectionAsViewer(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsViewer(stringSelection, NOT_EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsViewer(StringSelection stringSelection, Color color) {
        SelectionsHelper.initSelectionAsViewerWithoutFontSize(stringSelection, color);
        stringSelection.biggerText(5);
        stringSelection.storeAsStandardFontSize();
        stringSelection.storeAsStandardLabelFontSize();
    }

    public static void initSelectionAsViewerWithoutFontSize(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsViewerWithoutFontSize(stringSelection, NOT_EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsViewerWithoutFontSize(StringSelection stringSelection, Color color) {
        stringSelection.setEditable(false);
        stringSelection.setFocusable(false);
        stringSelection.setMonospacedFont();
        stringSelection.switchLabelToBold();
        stringSelection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsEditor(stringSelection, EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsEditor(StringSelection stringSelection, Color color) {
        stringSelection.setEditable(true);
        stringSelection.setFocusable(true);
        stringSelection.setMonospacedFont();
        stringSelection.switchLabelToBold();
        stringSelection.biggerText(5);
        stringSelection.storeAsStandardFontSize();
        stringSelection.storeAsStandardLabelFontSize();
        stringSelection.setBackgroundColor(color);
        stringSelection.setRedCaretColor();
    }

    public static void initSelectionAsViewer(TextAreaSelection textAreaSelection) {
        SelectionsHelper.initSelectionAsViewer(textAreaSelection, NOT_EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsViewer(TextAreaSelection textAreaSelection, Color color) {
        textAreaSelection.setEditable(false);
        textAreaSelection.setFocusable(false);
        textAreaSelection.setMonospacedFont();
        textAreaSelection.swithLabelToBold();
        textAreaSelection.biggerText(5);
        textAreaSelection.storeAsStandardFontSize();
        textAreaSelection.storeAsStandardLabelFontSize();
        textAreaSelection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(TextAreaSelection textAreaSelection) {
        SelectionsHelper.initSelectionAsEditor(textAreaSelection, NOT_EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsEditor(TextAreaSelection textAreaSelection, Color color) {
        textAreaSelection.setEditable(true);
        textAreaSelection.setFocusable(true);
        textAreaSelection.setMonospacedFont();
        textAreaSelection.swithLabelToBold();
        textAreaSelection.biggerText(5);
        textAreaSelection.storeAsStandardFontSize();
        textAreaSelection.storeAsStandardLabelFontSize();
        textAreaSelection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(ComboBoxSelection comboBoxSelection) {
        SelectionsHelper.initSelectionAsEditor(comboBoxSelection, EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsEditor(ComboBoxSelection comboBoxSelection, Color color) {
        comboBoxSelection.setEditable(true);
        comboBoxSelection.setFocusable(true);
        comboBoxSelection.setMonospacedFont();
        comboBoxSelection.switchLabelToBold();
        comboBoxSelection.biggerText(5);
        comboBoxSelection.storeAsStandardFontSize();
        comboBoxSelection.storeAsStandardLabelFontSize();
        comboBoxSelection.setBackgroundColor(color);
        comboBoxSelection.setRedCaretColor();
    }

    public static void initSelectionAsViewer(ComboBoxSelection comboBoxSelection) {
        comboBoxSelection.setEditable(false);
        comboBoxSelection.setFocusable(true);
        comboBoxSelection.setMonospacedFont();
        comboBoxSelection.switchLabelToBold();
        comboBoxSelection.biggerText(5);
        comboBoxSelection.storeAsStandardFontSize();
        comboBoxSelection.storeAsStandardLabelFontSize();
        comboBoxSelection.setBackgroundColor(EDITABLE_FIELD_COLOR);
        comboBoxSelection.setRedCaretColor();
    }

    public static StringSelection createViewerStringSelection(String string, String string2) {
        StringSelection stringSelection = new StringSelection(string);
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setFocusable(true);
        stringSelection.setText(string2);
        return stringSelection;
    }
}

