/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class DialogHelper {
    private DialogHelper() {
    }

    public static void addEscapeBehaviourForJDialog(JDialog jDialog) {
        JRootPane jRootPane = jDialog.getRootPane();
        DialogHelper.addEscapeBehaviour(jRootPane, jDialog);
    }

    public static void addEscapeBehaviourForJFrame(JFrame jFrame) {
        JRootPane jRootPane = jFrame.getRootPane();
        DialogHelper.addEscapeBehaviour(jRootPane, jFrame);
    }

    private static void addEscapeBehaviour(JRootPane jRootPane, final Window window) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                window.setVisible(false);
                window.dispose();
            }
        };
        DialogHelper.addEscapeBehaviour(jRootPane, window, runnable);
    }

    public static void addEscapeBehaviourForDialogBase(AbstractDialogBase abstractDialogBase) {
        JRootPane jRootPane = abstractDialogBase.getRootPane();
        DialogHelper.addEscapeBehaviour(jRootPane, abstractDialogBase.getWindow(), () -> abstractDialogBase.closeOrCallQuitter());
    }

    private static void addEscapeBehaviour(JRootPane jRootPane, Window window, final Runnable runnable) {
        InputMap inputMap = jRootPane.getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "ESCAPE");
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        jRootPane.getActionMap().put("ESCAPE", abstractAction);
    }
}

