/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.values;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class EnterTwoValuesDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(500, 120);
    private final String firstQuestion;
    private final String firstPresetting;
    private final JTextField firstValueField;
    private final String secondQuestion;
    private final String secondPresetting;
    private final JTextField secondValueField;
    private boolean applyOk;

    public EnterTwoValuesDialog(Point point, Image image, String string, String string2, String string3, String string4, String string5) {
        this(null, point, image, string, string2, string3, string4, string5);
    }

    public EnterTwoValuesDialog(Colorizer colorizer, Point point, Image image, String string, String string2, String string3, String string4, String string5) {
        super(point, image, string, DIALOG_DIMENSION, colorizer);
        this.firstQuestion = string2;
        this.firstPresetting = string3;
        this.secondQuestion = string4;
        this.secondPresetting = string5;
        this.firstValueField = new JTextField();
        this.secondValueField = new JTextField();
        this.fillDialog();
        this.addClosingWindowListener(() -> this.escape());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainFrame(), "Center");
        this.setKeyBindings();
    }

    private Component createMainFrame() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 0, 5, 5));
        jPanel.add(this.createFirstPart());
        jPanel.add(this.createSecondPart());
        return jPanel;
    }

    private Component createFirstPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFirstQuestionPart(), "Center");
        jPanel.add(this.createEnterFirstValuePart(), "South");
        return jPanel;
    }

    private Component createFirstQuestionPart() {
        JLabel jLabel = new JLabel(this.firstQuestion);
        this.setColors(jLabel);
        return jLabel;
    }

    private Component createEnterFirstValuePart() {
        this.setColors(this.firstValueField);
        this.firstValueField.setCaretColor(Color.RED);
        this.firstValueField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    EnterTwoValuesDialog.this.secondValueField.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.firstValueField.setText(this.firstPresetting);
        this.firstValueField.selectAll();
        return this.firstValueField;
    }

    private Component createSecondPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSecondQuestionPart(), "Center");
        jPanel.add(this.createEnterSecondValuePart(), "South");
        return jPanel;
    }

    private Component createSecondQuestionPart() {
        JLabel jLabel = new JLabel(this.secondQuestion);
        this.setColors(jLabel);
        return jLabel;
    }

    private Component createEnterSecondValuePart() {
        this.setColors(this.secondValueField);
        this.secondValueField.setCaretColor(Color.RED);
        this.secondValueField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    EnterTwoValuesDialog.this.applyDialog();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.secondValueField.setText(this.secondPresetting);
        this.secondValueField.selectAll();
        return this.secondValueField;
    }

    private void setKeyBindings() {
        this.setKeyBindingEscape(() -> this.escape());
    }

    private void escape() {
        this.firstValueField.setText("");
        this.secondValueField.setText("");
        this.applyOk = false;
        this.closeDialog();
    }

    private void applyDialog() {
        this.applyOk = false;
        this.apply();
        if (this.applyOk) {
            this.closeDialog();
        }
    }

    protected abstract void apply();

    protected void applyFailure(String string) {
        this.createErrorHandler().error(string);
        this.applyOk = false;
    }

    protected void applyOk() {
        this.applyOk = true;
    }

    public String getFirstValue() {
        return this.firstValueField.getText().trim();
    }

    public String getSecondValue() {
        return this.secondValueField.getText().trim();
    }

    public boolean isApplyOk() {
        return this.applyOk;
    }
}

