/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class CountLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private volatile String startText;
    private volatile String endText;
    private int count;

    public CountLabel() {
        this("", 0, "");
    }

    public CountLabel(String string) {
        this(string, 0, "");
    }

    public CountLabel(String string, String string2) {
        this(string, 0, string2);
    }

    public CountLabel(String string, int n, String string2) {
        this.startText = string;
        this.count = n;
        this.endText = string2;
        GuiTools.setMonospacedFont(this);
        this.setCounterAsText();
    }

    private void setCounterAsText() {
        SwingUtilities.invokeLater(() -> this.setCounterAsTextInEdt());
    }

    private void setCounterAsTextInEdt() {
        this.setText(this.startText + NumberString.taupu(this.count) + this.endText);
    }

    public void setStartText(String string) {
        this.startText = string;
        this.setCounterAsText();
    }

    public void setEndText(String string) {
        this.endText = string;
        this.setCounterAsText();
    }

    public void setCount(int n) {
        this.count = n;
        this.setCounterAsText();
    }

    public void increment() {
        ++this.count;
        this.setCounterAsText();
    }

    @Override
    public String toString() {
        return "CountLabel [startText=" + this.startText + ", endText=" + this.endText + ", count=" + this.count + "]";
    }
}

