/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.arrowselector;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ArrowButton
extends JRadioButton {
    private static final long serialVersionUID = -8818232289745150208L;
    private static final int HEIGHT_DIVISOR = 4;
    private static final int WIDTH_DIVISOR = 4;
    private static final int ARROW_DISTANCE = 2;
    private final JPanel surroundingPanel;
    private final int place;
    private final Color selectedColor;
    private final Color notSelectedColor;

    public ArrowButton(JPanel jPanel, int n, Color color, Color color2) {
        this.surroundingPanel = jPanel;
        this.place = n;
        this.selectedColor = color;
        this.notSelectedColor = color2;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this.paintTheArrow((Graphics2D)graphics);
        }
    }

    private void paintTheArrow(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        graphics2D.setBackground(this.surroundingPanel.getBackground());
        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
        Shape shape = null;
        shape = 0 == this.place ? this.createRectangle(dimension) : this.createArrow(dimension);
        graphics2D.setColor(this.isSelected() ? this.selectedColor : this.notSelectedColor);
        graphics2D.fill(shape);
    }

    private Rectangle createRectangle(Dimension dimension) {
        int n = dimension.width / 4;
        int n2 = dimension.height / 4;
        int n3 = dimension.width / 2;
        int n4 = dimension.height / 2;
        return new Rectangle(n, n2, n3, n4);
    }

    private Polygon createArrow(Dimension dimension) {
        int n = dimension.height / 4;
        int n2 = n * 3;
        int n3 = (n2 - n) / 2;
        int n4 = n3 / 9;
        int n5 = (9 - Math.abs(this.place)) * n4;
        int n6 = 2;
        int n7 = dimension.width - 2;
        int n8 = n5;
        int n9 = dimension.height / 2;
        int n10 = dimension.height - n5;
        if (this.place < 0) {
            int n11 = n7;
            n7 = n6;
            n6 = n11;
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(n6, n8);
        polygon.addPoint(n7, n9);
        polygon.addPoint(n6, n10);
        return polygon;
    }
}

