/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.pictures;

import de.duehl.swing.ui.elements.pictures.MouseWheelReactor;
import de.duehl.swing.ui.elements.pictures.PictureCache;
import de.duehl.swing.ui.elements.pictures.PicturePanelHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class PicturePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final PictureCache CACHE = new PictureCache(10000);
    private BufferedImage image;
    private int imageWidth;
    private int imageHeight;
    private Color backgroundColor;
    private boolean allowBiggerPicture;
    private int horizontalAlignment;
    private boolean missingPicturesAllowed;
    private boolean cacheImages;

    public PicturePanel() {
        this.setAllowBiggerPicture(true);
        this.setHorizontalCentered();
        this.missingPicturesAllowed = false;
    }

    public PicturePanel(String string) {
        this();
        this.loadPicture(string);
    }

    public void setAllowBiggerPicture(boolean bl) {
        this.allowBiggerPicture = bl;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setHorizontalCentered() {
        this.horizontalAlignment = 0;
    }

    public void setHorizontalLeft() {
        this.horizontalAlignment = 2;
    }

    public void setHorizontalRight() {
        this.horizontalAlignment = 4;
    }

    public void allowMissingPictures() {
        this.missingPicturesAllowed = true;
    }

    public void usePictureCache() {
        this.cacheImages = true;
    }

    public void loadPicture(String string) {
        if (this.cacheImages && CACHE.isFilenameKnown(string)) {
            this.loadPictureFromCache(string);
        } else {
            this.reallyLoadPicture(string);
            if (this.cacheImages && this.image != null) {
                CACHE.store(string, this.image);
            }
        }
    }

    private void loadPictureFromCache(String string) {
        this.image = CACHE.load(string);
        this.imageWidth = this.image.getWidth();
        this.imageHeight = this.image.getHeight();
    }

    private void reallyLoadPicture(String string) {
        try {
            this.tryToLoadPicture(string);
        }
        catch (Exception exception) {
            this.handleLoadException(string, exception);
        }
    }

    private void tryToLoadPicture(String string) throws IOException {
        this.image = ImageIO.read(new File(string));
        this.imageWidth = this.image.getWidth();
        this.imageHeight = this.image.getHeight();
    }

    private void handleLoadException(String string, Exception exception) {
        this.image = null;
        this.imageWidth = -1;
        this.imageHeight = -1;
        if (!this.missingPicturesAllowed) {
            throw new RuntimeException("Fehler beim Einlesen des Bildes '" + string + "': " + exception.getMessage());
        }
    }

    public void setPictureDirectly(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (bufferedImage == null) {
            this.imageWidth = -1;
            this.imageHeight = -1;
            if (!this.missingPicturesAllowed) {
                throw new RuntimeException("Es wurde ein null-Bildes direkt gesetzt.");
            }
        } else {
            this.imageWidth = bufferedImage.getWidth();
            this.imageHeight = bufferedImage.getHeight();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (null != this.backgroundColor) {
            this.drawBackgroundColor(graphics2D);
        }
        if (null != this.image) {
            this.setRenderingHints(graphics2D);
            this.drawImage(graphics2D);
        }
        graphics2D.dispose();
    }

    private void drawBackgroundColor(Graphics2D graphics2D) {
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    private void drawImage(Graphics2D graphics2D) {
        int n;
        int n2;
        double d;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        double d2 = this.computeFactor(this.imageWidth, n3);
        double d3 = d2 < (d = this.computeFactor(this.imageHeight, n4)) ? d2 : d;
        int n5 = (int)((double)this.imageWidth * d3);
        int n6 = (int)((double)this.imageHeight * d3);
        if (n5 < n3) {
            if (this.horizontalAlignment == 0) {
                n2 = (n3 - n5) / 2;
            } else if (this.horizontalAlignment == 2) {
                n2 = 0;
            } else if (this.horizontalAlignment == 4) {
                n2 = n3 - n5;
            } else {
                throw new RuntimeException("Unbekannte horizontalAlignment: '" + this.horizontalAlignment + "'");
            }
            n = 0;
        } else if (n6 < n4) {
            n2 = 0;
            n = (n4 - n6) / 2;
        } else {
            n2 = 0;
            n = 0;
        }
        graphics2D.drawImage(this.image, n2, n, n5, n6, null);
    }

    private double computeFactor(int n, int n2) {
        if (n <= n2 && !this.allowBiggerPicture) {
            return 1.0;
        }
        return (double)n2 / (double)n;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void createAndAddMouseWheelListener(MouseWheelReactor mouseWheelReactor) {
        this.addMouseWheelListener(PicturePanelHelper.createMouseWheelListener(mouseWheelReactor));
    }
}

