/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.project.gateway;

import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.combination.CombinationElementList;
import de.duehl.swing.ui.filter.project.gateway.DescriptionToTypeTranslater;
import de.duehl.swing.ui.filter.project.gateway.data.DescriptionAndFilterType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FilterGateway<Data, Type>
implements DescriptionToTypeTranslater<Type> {
    private final List<String> methods = new ArrayList<String>();
    private final List<String> paramisedMethods = new ArrayList<String>();
    private final Map<String, Type> descriptionToType;

    protected FilterGateway(List<DescriptionAndFilterType<Type>> list, List<DescriptionAndFilterType<Type>> list2) {
        Type Type2;
        String string;
        for (DescriptionAndFilterType<Type> descriptionAndFilterType : list) {
            string = descriptionAndFilterType.getDescription();
            this.methods.add(string);
        }
        for (DescriptionAndFilterType<Type> descriptionAndFilterType : list2) {
            string = descriptionAndFilterType.getDescription();
            this.paramisedMethods.add(string);
        }
        this.checkMethodsAndParamisedMethods();
        this.descriptionToType = new HashMap<String, Type>();
        for (DescriptionAndFilterType<Type> descriptionAndFilterType : list) {
            string = descriptionAndFilterType.getDescription();
            Type2 = descriptionAndFilterType.getFilterType();
            this.descriptionToType.put(string, Type2);
        }
        for (DescriptionAndFilterType<Type> descriptionAndFilterType : list2) {
            string = descriptionAndFilterType.getDescription();
            Type2 = descriptionAndFilterType.getFilterType();
            this.descriptionToType.put(string, Type2);
        }
    }

    private void checkMethodsAndParamisedMethods() {
        FilterGateway.checkNotSelfContained(this.methods);
        FilterGateway.checkNotSelfContained(this.paramisedMethods);
        this.checkNotContainedByOther(this.methods, this.paramisedMethods);
        this.checkNotContainedByOther(this.paramisedMethods, this.methods);
    }

    private static void checkNotSelfContained(List<String> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            String string = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                String string2 = list.get(j);
                if (!string.equals(string2)) continue;
                throw new FilterException("Nicht eindeutig: In der Liste der Methoden oder der parametrisierten Methoden kommt die Beschreibung '" + string + "' zweimal vor, n\u00e4mlich an Index " + i + " und an Index " + j + "!");
            }
        }
    }

    private void checkNotContainedByOther(List<String> list, List<String> list2) {
        for (String string : list) {
            if (!list2.contains(string)) continue;
            throw new RuntimeException("Nicht eindeutig: In der Liste der Methoden oder der parametrisierten Methoden kommt die Beschreibung '" + string + "' sowohl in der Liste mit den parameterl\u00f6osen als auch in der Liste mit den parametrisierbaren Methoden vor!");
        }
    }

    public final boolean hasMethods() {
        return !this.methods.isEmpty();
    }

    public final List<String> getMethods() {
        return this.methods;
    }

    public final boolean hasParamisedMethods() {
        return !this.paramisedMethods.isEmpty();
    }

    public final List<String> getParamisedMethods() {
        return this.paramisedMethods;
    }

    @Override
    public Type getTypeForDescription(String string) {
        if (!this.descriptionToType.containsKey(string)) {
            throw new FilterException("Zur Beschreibung '" + string + "' ist kein FilterTyp bekannt!");
        }
        return this.descriptionToType.get(string);
    }

    public abstract boolean isFilterCombinedMethods();

    public abstract void setRealFilter(CombinationElementList<Data> var1);
}

