/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.buttonbar;

import de.duehl.basics.history.HistoryStateDisplayer;
import de.duehl.swing.ui.elements.fontsize.FontSizeSelection;
import de.duehl.swing.ui.highlightingeditor.buttonbar.EditorForButtonBar;
import de.duehl.swing.ui.highlightingeditor.buttonbar.resources.IconDefinitions;
import de.duehl.swing.ui.resources.IconLoader;
import de.duehl.swing.ui.undoredo.UndoRedoBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonBar
implements HistoryStateDisplayer {
    private final EditorForButtonBar editor;
    private final IconLoader iconLoader;
    private final JPanel panel;
    private final FontSizeSelection fontSizeSelection;
    private final UndoRedoBar undoRedoBar;

    public ButtonBar(EditorForButtonBar editorForButtonBar) {
        this.editor = editorForButtonBar;
        IconDefinitions iconDefinitions = new IconDefinitions();
        this.iconLoader = iconDefinitions.createIconLoader();
        this.fontSizeSelection = new FontSizeSelection(editorForButtonBar);
        this.undoRedoBar = new UndoRedoBar(editorForButtonBar);
        this.panel = new JPanel();
        this.populatePanel();
    }

    private void populatePanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createFileOperationsPanel(), "West");
        this.fillWithouFilePanel();
    }

    private Component createFileOperationsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createNewFileButton());
        jPanel.add(this.createOpenFileButton());
        jPanel.add(this.createSaveFileButton());
        jPanel.add(this.createSaveAsFileButton());
        return jPanel;
    }

    public void removeFileOperationsPanel() {
        this.panel.removeAll();
        this.fillWithouFilePanel();
    }

    private void fillWithouFilePanel() {
        this.panel.add(this.createUndoRedoBar(), "Center");
        this.panel.add(this.fontSizeSelection.getComponent(), "East");
    }

    private Component createUndoRedoBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.undoRedoBar.getComponent(), "West");
        return jPanel;
    }

    private Component createNewFileButton() {
        JButton jButton = this.createButton("FILE_NEW");
        jButton.addActionListener(actionEvent -> this.editor.newFile());
        jButton.setToolTipText("Neue Datei: Leert den Editor und den Dateinamen.");
        return jButton;
    }

    private Component createOpenFileButton() {
        JButton jButton = this.createButton("FILE_LOAD");
        jButton.addActionListener(actionEvent -> this.editor.openFile());
        jButton.setToolTipText("Datei laden: Liest die Datei neu ein.");
        return jButton;
    }

    private Component createSaveFileButton() {
        JButton jButton = this.createButton("FILE_SAVE");
        jButton.addActionListener(actionEvent -> this.editor.saveFile());
        jButton.setToolTipText("Datei speichern: Speichet die Datei unter dem hinterlegten Dateinamen ab.");
        return jButton;
    }

    private Component createSaveAsFileButton() {
        JButton jButton = this.createButton("FILE_SAVE_AS");
        jButton.addActionListener(actionEvent -> this.editor.saveFileAs());
        jButton.setToolTipText("Datei speichern unter: Fragt nach einem neuen Dateinamen und speichert unter diesem.");
        return jButton;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(this.iconLoader.loadIcon(string));
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setOpaque(true);
        return jButton;
    }

    public void refreshFontSize() {
        this.fontSizeSelection.refreshFontSize();
    }

    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void enableUndo() {
        this.undoRedoBar.enableUndo();
    }

    @Override
    public void disableUndo() {
        this.undoRedoBar.disableUndo();
    }

    @Override
    public void enableRedo() {
        this.undoRedoBar.enableRedo();
    }

    @Override
    public void disableRedo() {
        this.undoRedoBar.disableRedo();
    }
}

