/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.io;

import de.duehl.basics.datetime.DateAndTimeHelper;
import de.duehl.basics.io.FileHelper;

public class WatchFileOnDiskChange {
    private static final boolean DEBUG = false;
    private boolean loadedOrSavedSuccessfully;
    private String filename;
    private long lastLoadOrSaveTimeInEditor;
    private long lastModificationTimeOnDisk;
    private boolean enabled;

    public WatchFileOnDiskChange() {
        this.enabled = true;
        this.notLoaded();
    }

    public WatchFileOnDiskChange(WatchFileOnDiskChange watchFileOnDiskChange) {
        this.loadedOrSavedSuccessfully = watchFileOnDiskChange.loadedOrSavedSuccessfully;
        this.filename = watchFileOnDiskChange.filename;
        this.lastLoadOrSaveTimeInEditor = watchFileOnDiskChange.lastLoadOrSaveTimeInEditor;
        this.lastModificationTimeOnDisk = watchFileOnDiskChange.lastModificationTimeOnDisk;
        this.enabled = watchFileOnDiskChange.enabled;
    }

    public void setEnabled(boolean bl) {
        this.say("enabled = " + bl);
        this.enabled = bl;
    }

    public void loadedSuccessfully(String string) {
        this.say("loaded: " + string);
        this.successfullySyncedWithDisk(string);
    }

    public void savedSuccessfully(String string) {
        this.say("saved: " + string);
        this.successfullySyncedWithDisk(string);
    }

    private void successfullySyncedWithDisk(String string) {
        this.filename = string;
        this.say("filename = " + string);
        this.lastLoadOrSaveTimeInEditor = System.currentTimeMillis();
        this.loadedOrSavedSuccessfully = true;
        this.lastModificationTimeOnDisk = this.determineModificationTimeOnDisc();
    }

    public void notLoaded() {
        this.say("not loaded");
        this.filename = "";
        this.loadedOrSavedSuccessfully = false;
    }

    public boolean doesFileNotExistAnymore() {
        this.say(this);
        if (!this.enabled || !this.loadedOrSavedSuccessfully) {
            this.say("not checked");
            return false;
        }
        boolean bl = FileHelper.exists(this.filename);
        this.say("Die Datei '" + this.filename + "' existiert" + (bl ? "" : " nicht") + ".");
        return !bl;
    }

    public boolean hasFileChangedOnDisk() {
        this.say(this);
        if (!this.enabled || !this.loadedOrSavedSuccessfully) {
            this.say("not checked");
            return false;
        }
        long l = this.determineModificationTimeOnDisc();
        this.say("lastLoadOrSaveTimeInEditor = " + this.millisToSTring(this.lastLoadOrSaveTimeInEditor));
        this.say("modificationTimeOnDisk     = " + this.millisToSTring(l));
        this.say("lastModificationTimeOnDisk = " + this.millisToSTring(this.lastModificationTimeOnDisk));
        boolean bl = this.lastLoadOrSaveTimeInEditor < l;
        this.say("newerOnDisc = " + bl);
        boolean bl2 = l < this.lastModificationTimeOnDisk;
        this.say("exchangedByOlderFile = " + bl2);
        boolean bl3 = bl || bl2;
        this.say("changedOnDisc = " + bl3);
        return bl3;
    }

    private String millisToSTring(long l) {
        return DateAndTimeHelper.millisToDateAndTimeString(l);
    }

    private long determineModificationTimeOnDisc() {
        return FileHelper.fileLastModifiedAsMillis(this.filename);
    }

    private void say(Object object) {
    }

    public String toString() {
        return "WatchFileOnDiskChange [loadedOrSavedSuccessfully=" + this.loadedOrSavedSuccessfully + ", filename=" + this.filename + ", lastLoadOrSaveTimeInEditor=" + this.lastLoadOrSaveTimeInEditor + ", lastModificationTimeOnDisk=" + this.lastModificationTimeOnDisk + ", enabled=" + this.enabled + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.enabled ? 1231 : 1237);
        n = 31 * n + (this.filename == null ? 0 : this.filename.hashCode());
        n = 31 * n + (int)(this.lastLoadOrSaveTimeInEditor ^ this.lastLoadOrSaveTimeInEditor >>> 32);
        n = 31 * n + (int)(this.lastModificationTimeOnDisk ^ this.lastModificationTimeOnDisk >>> 32);
        n = 31 * n + (this.loadedOrSavedSuccessfully ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WatchFileOnDiskChange watchFileOnDiskChange = (WatchFileOnDiskChange)object;
        if (this.enabled != watchFileOnDiskChange.enabled) {
            return false;
        }
        if (this.filename == null ? watchFileOnDiskChange.filename != null : !this.filename.equals(watchFileOnDiskChange.filename)) {
            return false;
        }
        if (this.lastLoadOrSaveTimeInEditor != watchFileOnDiskChange.lastLoadOrSaveTimeInEditor) {
            return false;
        }
        if (this.lastModificationTimeOnDisk != watchFileOnDiskChange.lastModificationTimeOnDisk) {
            return false;
        }
        return this.loadedOrSavedSuccessfully == watchFileOnDiskChange.loadedOrSavedSuccessfully;
    }
}

