/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.generic;

import de.duehl.swing.ui.tabs.bars.generic.ComponentCreator;
import de.duehl.swing.ui.tabs.bars.generic.TabBar;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoringTabBar<Creator extends ComponentCreator>
extends TabBar<Component> {
    private final List<String> titles = new ArrayList<String>();
    private final Map<String, Creator> creatorsByTitles = new HashMap<String, Creator>();

    public StoringTabBar(boolean bl) {
        super(bl);
    }

    public void addTab(String string, Creator Creator) {
        super.addTab(string, Creator.createComponent());
        this.titles.add(string);
        this.creatorsByTitles.put(string, Creator);
    }

    @Override
    public void removeTab(String string) {
        super.removeTab(string);
        this.creatorsByTitles.remove(string);
        this.titles.remove(string);
    }

    @Override
    public void removeAllTabs() {
        super.removeAllTabs();
        this.creatorsByTitles.clear();
        this.titles.clear();
    }

    public List<Creator> getCreators() {
        ArrayList<ComponentCreator> arrayList = new ArrayList<ComponentCreator>();
        for (String string : this.titles) {
            arrayList.add((ComponentCreator)this.creatorsByTitles.get(string));
        }
        return arrayList;
    }
}

