/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.timer;

import java.util.Timer;
import java.util.TimerTask;

public class WaitingUserInputTimer {
    private final Runnable runnable;
    private final long milliseconds;
    private Timer timer;
    private boolean running;

    public WaitingUserInputTimer(Runnable runnable, long l) {
        this.milliseconds = l;
        this.runnable = runnable;
        this.running = false;
        this.startTimer();
    }

    private synchronized void startTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                WaitingUserInputTimer.this.running = false;
                WaitingUserInputTimer.this.runnable.run();
            }
        }, this.milliseconds);
        this.running = true;
    }

    public synchronized boolean hasStopped() {
        return !this.running;
    }

    public synchronized void restart() {
        this.timer.cancel();
        this.startTimer();
    }

    public void cancel() {
        this.timer.cancel();
        this.running = false;
    }
}

