/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.update;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import de.duehl.swing.ui.elements.watch.CountDownWatchLabel;
import de.duehl.swing.ui.update.UpdateLogic;
import de.duehl.swing.ui.update.data.LabelAndTitle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class UpdateGui {
    private static final String INTERVAL_TITLE = "Aktualisierungsintervall";
    private static final String LAST_DURATION_TITLE = "Letzte Ausf\u00fchrungsdauer";
    private static final String COUNT_TITLE = "Anzahl Aktualisierungen";
    private static final String START_DATE_TITLE = "Datum letzte Aktualisierung";
    private static final String START_TIME_TITLE = "Uhrzeit letzte Aktualisierung";
    private static final String COUNT_DOWN_TITLE = "N\u00e4chsten Aktualisierung in";
    private final AbstractDialogBase gui;
    private final JLabel intervalLabel;
    private final JLabel lastDurationLabel;
    private final JLabel countLabel;
    private final JLabel startDateLabel;
    private final JLabel startTimeLabel;
    private final CountDownWatchLabel countDownWatchLabel;
    private final JButton updateNowButton;
    private UpdateLogic logic;
    private final List<LabelAndTitle> labelsAndTitles;
    private int addToFontSize;

    public UpdateGui(AbstractDialogBase abstractDialogBase) {
        this.gui = abstractDialogBase;
        this.intervalLabel = new JLabel("... bitte warten ...");
        this.lastDurationLabel = new JLabel("noch nicht gelaufen");
        this.countLabel = new JLabel("0");
        this.startDateLabel = new JLabel("noch nicht gelaufen");
        this.startTimeLabel = new JLabel("noch nicht gelaufen");
        this.countDownWatchLabel = new CountDownWatchLabel(0L);
        this.updateNowButton = new JButton("Aktualisieren");
        this.labelsAndTitles = CollectionsHelper.buildListFrom(new LabelAndTitle(INTERVAL_TITLE, this.intervalLabel), new LabelAndTitle(LAST_DURATION_TITLE, this.lastDurationLabel), new LabelAndTitle(COUNT_TITLE, this.countLabel), new LabelAndTitle(START_DATE_TITLE, this.startDateLabel), new LabelAndTitle(START_TIME_TITLE, this.startTimeLabel), new LabelAndTitle(COUNT_DOWN_TITLE, this.countDownWatchLabel));
        this.addToFontSize = 0;
    }

    void setlogic(UpdateLogic updateLogic) {
        this.logic = updateLogic;
    }

    public void setAddToFontSize(int n) {
        this.addToFontSize = n;
    }

    public JPanel createUpdateGridPanel() {
        JPanel jPanel = new JPanel();
        GuiTools.createTitle("", jPanel);
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        for (LabelAndTitle labelAndTitle : this.labelsAndTitles) {
            this.addTitledLabel(jPanel, labelAndTitle.getTitle(), labelAndTitle.getLabel());
        }
        return jPanel;
    }

    private void addTitledLabel(JPanel jPanel, String string, JLabel jLabel) {
        JLabel jLabel2 = this.createCalculationTitleLabel(string);
        GuiTools.biggerFont(jLabel2, this.addToFontSize);
        jPanel.add(jLabel2);
        GuiTools.biggerFont(jLabel, this.addToFontSize);
        jPanel.add(jLabel);
    }

    private JLabel createCalculationTitleLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(new EmptyBorder(0, 30, 0, 0));
        return jLabel;
    }

    public JPanel createUpdateGridBagPanel() {
        JPanel jPanel = new JPanel();
        GuiTools.createTitle("", jPanel);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        for (LabelAndTitle labelAndTitle : this.labelsAndTitles) {
            this.addGriddedTitledPanel(jPanel, gridBagConstraints, labelAndTitle.getTitle(), labelAndTitle.getLabel());
        }
        return jPanel;
    }

    private void addGriddedTitledPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, String string, JLabel jLabel) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel2 = new JLabel(string);
        GuiTools.biggerFont(jLabel2, this.addToFontSize);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        GuiTools.biggerFont(jLabel, this.addToFontSize);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public Component createUpdateButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.createChangeUpdateIntervalButton());
        jPanel.add(this.createUpdateNowButton());
        return jPanel;
    }

    private Component createChangeUpdateIntervalButton() {
        JButton jButton = new JButton("Aktualisierungsintervall \u00e4ndern ...");
        jButton.setFocusable(false);
        jButton.setEnabled(true);
        jButton.addActionListener(actionEvent -> this.changeUpdateInterval());
        return jButton;
    }

    private void changeUpdateInterval() {
        String string = GuiTools.askUserToEnterAStringValue("Aktualisierungsintervall festlegen", "Bitte geben Sie das neue Aktualisierungsintervall in Sekunden ein:");
        if (!string.isEmpty()) {
            if (NumberString.isDigitSequence(string)) {
                int n = Integer.parseInt(string);
                this.checkAndPerhapsSetUpdateIntervalInSeconds(n);
            } else {
                GuiTools.informUser(this.gui.getWindowAsComponent(), "Fehlerhaftes Aktualisierungsintervall eingegeben!", "Bitte geben Sie eine Zahl ein!");
            }
        }
    }

    private boolean checkAndPerhapsSetUpdateIntervalInSeconds(int n) {
        return this.checkAndPerhapsSetUpdateIntervalInSeconds(n, true);
    }

    public boolean checkAndPerhapsSetUpdateIntervalInSecondsWithoutRun(int n) {
        return this.checkAndPerhapsSetUpdateIntervalInSeconds(n, false);
    }

    private boolean checkAndPerhapsSetUpdateIntervalInSeconds(int n, boolean bl) {
        String string = this.logic.checkUpdateIntervalInSecondsIsInRange(n);
        if (string.isEmpty()) {
            if (bl) {
                this.logic.setUpdateIntervalInSeconds(n);
            } else {
                this.logic.setUpdateIntervalInSecondsWithoutRun(n);
            }
            return true;
        }
        GuiTools.informUser(this.gui.getWindowAsComponent(), "Fehlerhaftes Aktualisierungsintervall eingegeben!", string);
        return false;
    }

    private Component createUpdateNowButton() {
        this.updateNowButton.setFocusable(false);
        this.updateNowButton.setEnabled(true);
        this.updateNowButton.addActionListener(actionEvent -> this.logic.updateNow());
        return this.updateNowButton;
    }

    public void showIntervalTimeInSeconds(int n) {
        Object object = n < 61 ? n + " Sekunden" : TimeHelper.secondsToHoursMinutesSeconds(n);
        this.intervalLabel.setText((String)object);
        this.intervalLabel.repaint();
    }

    public void jobDone(String string, int n, DateAndTime dateAndTime) {
        SwingUtilities.invokeLater(() -> this.jobDoneInEdt(string, n, dateAndTime));
    }

    private void jobDoneInEdt(String string, int n, DateAndTime dateAndTime) {
        this.lastDurationLabel.setText(string);
        this.countLabel.setText(NumberString.taupu(n));
        String string2 = dateAndTime.getDate().toString();
        String string3 = dateAndTime.getTime().toString();
        this.startDateLabel.setText(string2);
        this.startTimeLabel.setText(string3);
        this.gui.repaint();
        this.gui.endLongTimeProcess();
        long l = TimeHelper.hoursMinutesSecondsToSeconds(string);
        this.logic.changeUpdateIntervalIfUpdateTookTooLong(l);
    }

    public void startLongTimeProcess(String string) {
        this.gui.startLongTimeProcess(string);
    }

    public void restartCountDownWatch(int n) {
        this.countDownWatchLabel.setDurationInSeconds(n);
        this.countDownWatchLabel.start();
    }

    public void quit() {
        this.countDownWatchLabel.stopActualisationRunnable();
    }

    public void pressActualizeButton() {
        this.updateNowButton.doClick();
    }
}

