/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.windowFocusFrame;

import de.duehl.swing.ui.windowFocusFrame.WindowFocusObservable;
import de.duehl.swing.ui.windowFocusFrame.WindowFocusObserver;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class JWindowFocusFrame
extends JFrame
implements WindowFocusObservable {
    private static final long serialVersionUID = 2608033940961073037L;
    private List<WindowFocusObserver> observers = new ArrayList<WindowFocusObserver>();

    public JWindowFocusFrame() {
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                JWindowFocusFrame.this.notifyObserversFocusGained();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                JWindowFocusFrame.this.notifyObserversFocusLost();
            }
        });
    }

    @Override
    public void addObserver(WindowFocusObserver windowFocusObserver) {
        this.observers.add(windowFocusObserver);
    }

    @Override
    public void deleteObserver(WindowFocusObserver windowFocusObserver) {
        this.observers.remove(windowFocusObserver);
    }

    @Override
    public void notifyObserversFocusGained() {
        for (WindowFocusObserver windowFocusObserver : this.observers) {
            windowFocusObserver.updateFocusGained();
        }
    }

    @Override
    public void notifyObserversFocusLost() {
        for (WindowFocusObserver windowFocusObserver : this.observers) {
            windowFocusObserver.updateFocusLost();
        }
    }
}

