/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.threads.timed;

import de.duehl.threads.debug.Debug;

public class TimedThreadRunner {
    private final int secondsBeforeKill;
    private final long millisecondsBetweenWatching;
    private final Runnable task;
    private TaskState taskState;

    public TimedThreadRunner(int n, long l, Runnable runnable) {
        this.secondsBeforeKill = n;
        this.millisecondsBetweenWatching = l;
        this.task = runnable;
        this.taskState = TaskState.NOT_STARTED;
    }

    public void runTask() {
        this.checkTaskStateAtStart();
        long l = System.currentTimeMillis();
        Thread thread = new Thread(this.task);
        thread.start();
        while (this.taskState == TaskState.RUNNING) {
            this.sleep();
            if (!thread.isAlive()) {
                Debug.say("thread wurde w\u00e4hrend des letzten Wartens beendet.");
                this.taskState = TaskState.FINISHED_IN_TIME;
                continue;
            }
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) / 1000L;
            if (l3 >= (long)this.secondsBeforeKill) {
                Debug.say("Zeit abgelaufen! Thread muss abgew\u00fcrgt werden...");
                thread.stop();
                this.taskState = TaskState.CANCELLED;
                continue;
            }
            Debug.say("Abbruchzeit noch nicht erreicht:\n\tAbbruch nach: " + this.secondsBeforeKill + "\n\tBisher      : " + l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTaskStateAtStart() {
        TimedThreadRunner timedThreadRunner = this;
        synchronized (timedThreadRunner) {
            if (this.taskState != TaskState.NOT_STARTED) {
                Debug.say("Pr\u00fcfung zu Beginn fehlgeschlagen.");
                throw new RuntimeException("runThread() darf nicht gestartet werden, wenn bereits ein Thread beobachtet wird oder wurde. Bitte erzeugen Sie sich ein neues Objekt der Klasse " + this.getClass().toString() + ".");
            }
            this.taskState = TaskState.RUNNING;
        }
        Debug.say("Pr\u00fcfung zu Beginn in Ordnung.");
    }

    private void sleep() {
        Debug.say("Warte " + this.millisecondsBetweenWatching + " Millisekunden...");
        try {
            Thread.sleep(this.millisecondsBetweenWatching);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public static enum TaskState {
        NOT_STARTED,
        RUNNING,
        FINISHED_IN_TIME,
        CANCELLED;

    }
}

