/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.twosidecommander.ui.list.element;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.move.SwitchableVerticalMoveButtons;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import de.duehl.twosidecommander.ui.list.data.ListElementDisplayerClickReactor;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ListElementDisplayer
implements VerticalMoveButtonsUser {
    private final ListElementMoveReactor listElementMoveReactor;
    private JPanel panel;
    private boolean showDetailsInRightClickMenu;
    private String showDetailsName;
    private ListElementDisplayerClickReactor listElementDisplayerClickReactor;
    private ListElementDisplayerClickReactor listElementDisplayerShiftClickReactor;
    private final SwitchableVerticalMoveButtons switchableMoveButtons;

    public ListElementDisplayer(ListElementMoveReactor listElementMoveReactor) {
        this.listElementMoveReactor = listElementMoveReactor;
        this.panel = new JPanel();
        this.showDetailsInRightClickMenu = false;
        this.showDetailsName = "";
        this.switchableMoveButtons = new SwitchableVerticalMoveButtons(this);
        this.init();
    }

    private void init() {
        this.initPanel();
        this.addMouseListener();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
    }

    private void addMouseListener() {
        this.panel.addMouseListener(this.createMouseAdapter());
    }

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (mouseEvent.isControlDown()) {
                    bl = true;
                }
                if (mouseEvent.isAltDown()) {
                    bl2 = true;
                }
                if (mouseEvent.isShiftDown()) {
                    bl3 = true;
                }
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    bl4 = true;
                }
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    bl5 = true;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    bl6 = true;
                }
                if (n == 1 && bl4 && !bl5 && !bl6) {
                    if (!(bl || bl2 || bl3)) {
                        ListElementDisplayer.this.reactOnSingleLeftMouseClick();
                    } else if (!bl && !bl2 && bl3) {
                        ListElementDisplayer.this.reactOnSingleShiftLeftMouseClick();
                    }
                }
            }
        };
    }

    private void reactOnSingleLeftMouseClick() {
        this.listElementDisplayerClickReactor.clickedOnListElement(this);
    }

    private void reactOnSingleShiftLeftMouseClick() {
        this.listElementDisplayerShiftClickReactor.clickedOnListElement(this);
    }

    public final void setListElementDisplayerClickReactor(ListElementDisplayerClickReactor listElementDisplayerClickReactor) {
        this.listElementDisplayerClickReactor = listElementDisplayerClickReactor;
    }

    public final void setListElementDisplayerShiftClickReactor(ListElementDisplayerClickReactor listElementDisplayerClickReactor) {
        this.listElementDisplayerShiftClickReactor = listElementDisplayerClickReactor;
    }

    public final void setListElementShowDetailsName(String string) {
        this.showDetailsName = string;
        this.showDetailsInRightClickMenu = true;
    }

    protected final void createGui() {
        if (this.showDetailsInRightClickMenu) {
            this.showDetailsInRightClickMenu();
        }
        this.setUpAndDownButtonColorsAndEnabled();
        this.panel.add(this.createElementDisplay(), "Center");
        this.panel.add((Component)GuiTools.centerVertical(this.switchableMoveButtons.getPanel()), "East");
    }

    private void showDetailsInRightClickMenu() {
        ListElementPopupMenu listElementPopupMenu = new ListElementPopupMenu(this.showDetailsName, () -> this.reactOnShowDetailsClickInRightClickMenu());
        this.panel.setComponentPopupMenu(listElementPopupMenu);
    }

    protected void reactOnShowDetailsClickInRightClickMenu() {
    }

    protected abstract Component createElementDisplay();

    public final JPanel getPanel() {
        return this.panel;
    }

    public abstract void showSelectedAndHighlighted();

    public abstract void showSelected();

    public abstract void showHighlighted();

    public abstract void showNormal();

    public abstract String getElementDescription();

    public final void showMoveButtonsOnListElements(boolean bl) {
        this.switchableMoveButtons.showMoveButtons(bl);
        this.panel.repaint();
    }

    @Override
    public final boolean canMoveButtonsUserMoveUp() {
        return this.listElementMoveReactor.canListElementMoveUp(this);
    }

    @Override
    public final boolean canMoveButtonsUserMoveDown() {
        return this.listElementMoveReactor.canListElementMoveDown(this);
    }

    @Override
    public final void moveMoveButtonsUserToFirst() {
        this.listElementMoveReactor.moveListElementToFirst(this);
    }

    @Override
    public final void moveMoveButtonsUserUp() {
        this.listElementMoveReactor.moveListElementUp(this);
    }

    @Override
    public final void moveMoveButtonsUserDown() {
        this.listElementMoveReactor.moveListElementDown(this);
    }

    @Override
    public final void moveMoveButtonsUserToLast() {
        this.listElementMoveReactor.moveListElementToLast(this);
    }

    public final void setUpAndDownButtonColorsAndEnabled() {
        this.switchableMoveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    public final boolean showsMoveButtons() {
        return this.switchableMoveButtons.isMoveButtonsShown();
    }
}

