/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import java.util.ArrayList;
import java.util.List;

public class KanjiSet {
    public static final String KANJI_SET_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "kanji_mengen");
    public static final String KANJI_SET_EXTENSION = ".kst";
    private String name;
    private final List<Kanji> set;

    public KanjiSet(String string) {
        if (string.isBlank()) {
            throw new RuntimeException("Der Name '" + string + "' ist unzul\u00e4ssig.");
        }
        this.name = string;
        this.set = new ArrayList<Kanji>();
    }

    public void addKanji(Kanji kanji) {
        if (this.set.contains((Object)kanji)) {
            throw new RuntimeException("Das Kanji ist bereit enthalten: " + kanji);
        }
        this.set.add(kanji);
    }

    public void addKanji(String string) {
        Kanji kanji = Kanji.getByCharacter(string);
        this.set.add(kanji);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<Kanji> getSet() {
        return this.set;
    }

    public String determineFilename() {
        return KanjiSet.determineFilename(this.name);
    }

    public static String determineFilename(String string) {
        String string2 = KanjiSet.determineBareFilename(string);
        String string3 = FileHelper.concatPathes(KANJI_SET_DIRECTORY, string2);
        return string3;
    }

    public static String determineBareFilename(String string) {
        String string2 = Text.createJavaVariableName(string) + KANJI_SET_EXTENSION;
        return string2;
    }
}

