/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.components.selections.data.SearchWordSelectionInputs;
import de.duehl.vocabulary.japanese.grammar.AdjectiveSearchWords;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Vocable {
    private String kana = "";
    private String compareKana = "";
    private String kanji = "";
    private String compareKanji = "";
    private String romaji = "";
    private String compareRomaji = "";
    private String pronunciation = "";
    private final List<String> translations = new ArrayList<String>();
    private final List<String> compareTranslations = new ArrayList<String>();
    private String bareMp3 = "";
    private String mp3 = "";
    private String comment = "";
    private List<String> searchWords = new ArrayList<String>();
    private List<String> partsOfSpeech = new ArrayList<String>();
    private String vocabularyDescription = "";

    public String getKana() {
        return this.kana;
    }

    public Vocable setKana(String string) {
        this.kana = string;
        this.compareKana = VocabularyTools.createCompareTranslation(string);
        return this;
    }

    public String getCompareKana() {
        return this.compareKana;
    }

    public String getKanji() {
        return this.kanji;
    }

    public Vocable setKanji(String string) {
        this.kanji = string;
        this.compareKanji = VocabularyTools.createCompareTranslation(string);
        return this;
    }

    public String getCompareKanji() {
        return this.compareKanji;
    }

    public String getRomaji() {
        return this.romaji;
    }

    public Vocable setRomaji(String string) {
        this.romaji = string;
        this.compareRomaji = VocabularyTools.createCompareTranslation(string);
        return this;
    }

    public String getCompareRomaji() {
        return this.compareRomaji;
    }

    public String getPronunciation() {
        return this.pronunciation;
    }

    public Vocable setPronunciation(String string) {
        this.pronunciation = string;
        return this;
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public Vocable addToTranslations(String string) {
        this.translations.add(string);
        String string2 = VocabularyTools.createCompareTranslation(string);
        this.compareTranslations.add(string2);
        return this;
    }

    public List<String> getCompareTranslations() {
        return this.compareTranslations;
    }

    public String getBareMp3() {
        return this.bareMp3;
    }

    public Vocable setBareMp3(String string) {
        this.bareMp3 = string;
        return this;
    }

    public String getMp3() {
        return this.mp3;
    }

    public Vocable setMp3(String string) {
        this.mp3 = string;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Vocable setComment(String string) {
        this.comment = string;
        return this;
    }

    public List<String> getSearchWords() {
        return this.searchWords;
    }

    public void setSearchWords(List<String> list) {
        this.searchWords = list;
    }

    public List<String> getPartsOfSpeech() {
        return this.partsOfSpeech;
    }

    public void setPartsOfSpeech(List<String> list) {
        this.partsOfSpeech = list;
    }

    public String getVocabularyDescription() {
        return this.vocabularyDescription;
    }

    public Vocable setVocabularyDescription(String string) {
        this.vocabularyDescription = string;
        return this;
    }

    public boolean kanaContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.singleWordContains(searchWordSelectionInputs, this.kana, this.compareKana);
    }

    public boolean kanjiContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.singleWordContains(searchWordSelectionInputs, this.kanji, this.compareKanji);
    }

    public boolean romajiContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.singleWordContains(searchWordSelectionInputs, this.romaji, this.compareRomaji);
    }

    public boolean pronunciationContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        String string = VocabularyTools.createCompareTranslation(this.pronunciation);
        return this.singleWordContains(searchWordSelectionInputs, this.pronunciation, string);
    }

    public boolean translationsContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.listOfWordsContains(searchWordSelectionInputs, this.translations, this.compareTranslations);
    }

    public boolean commentContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        String string = VocabularyTools.createCompareTranslation(this.comment);
        return this.singleWordContains(searchWordSelectionInputs, this.comment, string);
    }

    public boolean searchWordsContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.listOfWordsContains(searchWordSelectionInputs, this.searchWords);
    }

    public boolean partOfSpeechContains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.listOfWordsContains(searchWordSelectionInputs, this.partsOfSpeech);
    }

    public boolean contains(SearchWordSelectionInputs searchWordSelectionInputs) {
        return this.kanaContains(searchWordSelectionInputs) || this.kanjiContains(searchWordSelectionInputs) || this.romajiContains(searchWordSelectionInputs) || this.pronunciationContains(searchWordSelectionInputs) || this.translationsContains(searchWordSelectionInputs) || this.commentContains(searchWordSelectionInputs) || this.searchWordsContains(searchWordSelectionInputs) || this.partOfSpeechContains(searchWordSelectionInputs);
    }

    private boolean singleWordContains(SearchWordSelectionInputs searchWordSelectionInputs, String string, String string2) {
        String string3;
        String string4;
        if (searchWordSelectionInputs.isWholeWordSearch()) {
            if (searchWordSelectionInputs.isCaseSensitiveSearch()) {
                string4 = searchWordSelectionInputs.getText();
                string3 = string;
            } else {
                string4 = Text.toLowerCase(searchWordSelectionInputs.getText());
                string3 = Text.toLowerCase(string);
            }
        } else if (searchWordSelectionInputs.isCaseSensitiveSearch()) {
            string4 = VocabularyTools.removePuncuationMarks(searchWordSelectionInputs.getText());
            string3 = VocabularyTools.removePuncuationMarks(string);
        } else {
            string4 = VocabularyTools.createCompareTranslation(searchWordSelectionInputs.getText());
            string3 = string2;
        }
        if (searchWordSelectionInputs.isWholeWordSearch()) {
            if (string3.contains(string4)) {
                Pattern pattern = Pattern.compile("\\b" + Pattern.quote(string4) + "\\b");
                Matcher matcher = pattern.matcher(string3);
                return matcher.find();
            }
            return false;
        }
        return string3.contains(string4);
    }

    private boolean listOfWordsContains(SearchWordSelectionInputs searchWordSelectionInputs, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = VocabularyTools.createCompareTranslation(string);
            arrayList.add(string2);
        }
        return this.listOfWordsContains(searchWordSelectionInputs, list, arrayList);
    }

    private boolean listOfWordsContains(SearchWordSelectionInputs searchWordSelectionInputs, List<String> list, List<String> list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Die beiden Listen haben verschieden viele Elemente!\nOriginale Werte:\n" + CollectionsHelper.listListNice(list) + "Vergleichs-Werte:\n" + CollectionsHelper.listListNice(list2));
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = list.get(i);
            if (!this.singleWordContains(searchWordSelectionInputs, string2, string = list2.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        String string2 = VocabularyTools.createCompareTranslation(string);
        boolean bl = this.containsInternal(string2);
        if (!bl) {
            bl = this.containsInternal(string);
        }
        return bl;
    }

    private boolean containsInternal(String string) {
        return this.compareKana.contains(string) || this.compareKanji.contains(string) || this.compareRomaji.contains(string) || this.pronunciation.contains(string) || this.translationsContainsInternal(string) || this.bareMp3containsInternal(string) || this.comment.contains(string) || this.searchWordsContainsInternal(string) || this.partOfSpeechContainsInternal(string);
    }

    private boolean translationsContainsInternal(String string) {
        for (String string2 : this.translations) {
            if (!string2.contains(string)) continue;
            return true;
        }
        for (String string2 : this.compareTranslations) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean bareMp3containsInternal(String string) {
        return this.bareMp3.contains(string);
    }

    private boolean searchWordsContainsInternal(String string) {
        for (String string2 : this.searchWords) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean partOfSpeechContainsInternal(String string) {
        for (String string2 : this.partsOfSpeech) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isVerb() {
        return this.partsOfSpeech.contains("Verb");
    }

    public boolean isVerbInWoerterbuchform() {
        return this.isVerb() && this.searchWords.contains("W\u00f6rterbuchform");
    }

    public boolean isAdjective() {
        return this.partsOfSpeech.contains("Adjektiv");
    }

    public boolean isAdjectivInPositivePresence() {
        return this.isAdjective() && (this.searchWords.contains("Positive Gegenwart I-Adjektiv") || this.searchWords.contains("Positive Gegenwart Na-Adjektiv"));
    }

    public boolean isIAdjective() {
        if (this.isAdjective()) {
            for (String string : this.searchWords) {
                if (!AdjectiveSearchWords.SORTED_I_ADJEKTIVE_SEARCH_WORDS.contains(string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isNaAdjective() {
        if (this.isAdjective()) {
            for (String string : this.searchWords) {
                if (!AdjectiveSearchWords.SORTED_NA_ADJEKTIVE_SEARCH_WORDS.contains(string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "Vocable [\n    kana=" + this.kana + ", \n    kanji=" + this.kanji + ", \n    romaji=" + this.romaji + ", \n    pronunciation=" + this.pronunciation + ", \n    translations=" + this.translations + ", \n    compareTranslations=" + this.compareTranslations + ", \n    bareMp3=" + this.bareMp3 + ", \n    mp3=" + this.mp3 + ", \n    comment=" + this.comment + ", \n    searchWords=" + this.searchWords + ", \n    partsOfSpeech=" + this.partsOfSpeech + ", \n    vocabularyDescription=" + this.vocabularyDescription + "\n]";
    }

    public String toNiceString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Text.multipleString(" ", Math.max(0, n - 4));
        String string2 = Text.multipleString(" ", n);
        stringBuilder.append(string + "Vocable:\n");
        stringBuilder.append(string2 + "Kana                 : " + this.kana + "\n");
        stringBuilder.append(string2 + "Kanji                : " + this.kanji + "\n");
        stringBuilder.append(string2 + "romaji               : " + this.romaji + "\n");
        stringBuilder.append(string2 + "pronunciation        : " + this.pronunciation + "\n");
        if (this.translations.size() == 1) {
            stringBuilder.append(string2 + "translation          : " + this.translations.get(0) + "\n");
        } else {
            stringBuilder.append(string2 + "translations :\n");
            for (String string3 : this.translations) {
                stringBuilder.append(string2 + "    " + string3 + "\n");
            }
        }
        stringBuilder.append(string2 + "bareMp3              : " + this.bareMp3 + "\n");
        stringBuilder.append(string2 + "mp3                  : " + this.mp3 + "\n");
        stringBuilder.append(string2 + "comment              : " + this.comment + "\n");
        if (this.partsOfSpeech.size() == 0) {
            stringBuilder.append(string2 + "partOfSpeech         : -\n");
        }
        if (this.partsOfSpeech.size() == 1) {
            stringBuilder.append(string2 + "partOfSpeech          : " + this.partsOfSpeech.get(0) + "\n");
        } else {
            stringBuilder.append(string2 + "partOfSpeech :\n");
            for (String string3 : this.partsOfSpeech) {
                stringBuilder.append(string2 + "    " + string3 + "\n");
            }
        }
        if (this.searchWords.size() == 0) {
            stringBuilder.append(string2 + "searchWords          : -\n");
        }
        if (this.searchWords.size() == 1) {
            stringBuilder.append(string2 + "searchWords          : " + this.searchWords.get(0) + "\n");
        } else {
            stringBuilder.append(string2 + "searchWords :\n");
            for (String string3 : this.searchWords) {
                stringBuilder.append(string2 + "    " + string3 + "\n");
            }
        }
        stringBuilder.append(string2 + "vocabularyDescription: " + this.vocabularyDescription + "\n");
        return stringBuilder.toString();
    }

    public String getKanaInJapaneseQuotes() {
        return "\u300c" + this.kana + "\u300d";
    }

    public String getKanjiInJapaneseQuotes() {
        return "\u300c" + this.kanji + "\u300d";
    }

    public String getKanjiKanaRomajiWithJapaneseBraces() {
        boolean bl;
        Object object = "";
        boolean bl2 = bl = !this.kanji.isEmpty() && !this.kanji.equals(this.kana);
        if (bl) {
            object = (String)object + this.getKanjiInJapaneseQuotes() + " (";
        }
        object = (String)object + this.getKanaInJapaneseQuotes();
        object = bl ? (String)object + ", " : (String)object + " (";
        object = (String)object + this.romaji + ")";
        return object;
    }

    public int hashCode() {
        return Objects.hash(this.bareMp3, this.comment, this.compareTranslations, this.kana, this.kanji, this.mp3, this.partsOfSpeech, this.pronunciation, this.romaji, this.searchWords, this.translations, this.vocabularyDescription);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vocable vocable = (Vocable)object;
        return Objects.equals(this.bareMp3, vocable.bareMp3) && Objects.equals(this.comment, vocable.comment) && Objects.equals(this.compareTranslations, vocable.compareTranslations) && Objects.equals(this.kana, vocable.kana) && Objects.equals(this.kanji, vocable.kanji) && Objects.equals(this.mp3, vocable.mp3) && Objects.equals(this.partsOfSpeech, vocable.partsOfSpeech) && Objects.equals(this.pronunciation, vocable.pronunciation) && Objects.equals(this.romaji, vocable.romaji) && Objects.equals(this.searchWords, vocable.searchWords) && Objects.equals(this.translations, vocable.translations) && Objects.equals(this.vocabularyDescription, vocable.vocabularyDescription);
    }
}

