/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.version.Version;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.version.NewsHelper;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.common.website.update.vocables.VocablesActualityChecker;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.io.AllKanjiSetsWriter;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.RealInternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.translation.GermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.logic.translation.JapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.startup.logic.StartupLoader;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.website.update.ownlists.GroupsOfOwnListsFromWebsiteImporter;
import de.duehl.vocabulary.japanese.website.update.ownlists.OwnListGroupsUpdater;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionsAndInterestUpdater;
import de.duehl.vocabulary.japanese.website.update.program.ProgramUpdatableChecker;
import de.duehl.vocabulary.japanese.website.update.vocables.VocablesUpdatableChecker;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class VocabularyTrainerLogic
implements Quitter {
    private final Version vocabularyTrainerVersion = new VocabularyTrainerVersion().getVersion();
    private final SessionManager sessionManager = new SessionManager(this.vocabularyTrainerVersion);
    private final Options options = this.loadOptions();
    private final VocabularyTrainerGui gui = new VocabularyTrainerGui(this);
    private List<Vocabulary> vocabularies;
    private String loadUpMessage;
    private OwnLists ownLists;
    private JapaneseToGermanTranslation japaneseToGermanTranslation;
    private GermanToJapaneseTranslation germanToJapaneseTranslation;
    private InternalDataRequester internalDataRequester;
    private String startUpLog;
    private boolean checkingNewVersionsOnStartUp = false;
    private boolean startUpErrorOccured;
    private WrongTestedVocables wrongTestedVocables;
    private InternalKanjiDataRequester internalKanjiDataRequester;
    private List<KanjiSet> kanjiSets;
    private RealInternalKanaDataRequester internalKanaDataRequester;

    private Options loadOptions() {
        try {
            return this.sessionManager.load();
        }
        catch (Exception exception) {
            if (this.gui == null) {
                System.out.println("Fehler beim Laden der Optionen: " + exception.getMessage());
                return new Options(this.vocabularyTrainerVersion);
            }
            ErrorHandler errorHandler = this.gui.createErrorHandler();
            errorHandler.error(exception.getMessage(), exception);
            return new Options(this.vocabularyTrainerVersion);
        }
    }

    public void saveOptions() {
        try {
            this.tryToSaveOption();
        }
        catch (Exception exception) {
            if (this.gui != null) {
                ErrorHandler errorHandler = this.gui.createErrorHandler();
                errorHandler.error(exception.getMessage(), exception);
            }
            throw new RuntimeException("Fehler beim Speichern der Optionen!", exception);
        }
    }

    private void tryToSaveOption() {
        this.storeToOptions();
        if (this.sessionManager != null) {
            this.sessionManager.save();
        }
    }

    private void storeToOptions() {
        if (null != this.options && this.gui != null) {
            this.options.setStringSelectionFontSize(this.gui.getStringSelectionFontSize());
            this.options.setStringSelectionLabelFontSize(this.gui.getStringSelectionLabelFontSize());
            this.gui.storeShownTabIndices();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public int getLastShownMainTabIndex() {
        if (null != this.options) {
            return this.options.getLastShownMainTabIndex();
        }
        return new Options(this.vocabularyTrainerVersion).getLastShownMainTabIndex();
    }

    public int getLastShownVocabularyCategoryTabIndex() {
        if (null != this.options) {
            return this.options.getLastShownVocabularyCategoryTabIndex();
        }
        return new Options(this.vocabularyTrainerVersion).getLastShownVocabularyCategoryTabIndex();
    }

    public int getLastShownOwnListCategoryTabIndex() {
        if (null != this.options) {
            return this.options.getLastShownOwnListCategoryTabIndex();
        }
        return new Options(this.vocabularyTrainerVersion).getLastShownOwnListCategoryTabIndex();
    }

    public int getLastShownVocabularySubCategoryTabIndex() {
        if (null != this.options) {
            return this.options.getLastShownVocabularySubCategoryTabIndex();
        }
        return new Options(this.vocabularyTrainerVersion).getLastShownVocabularySubCategoryTabIndex();
    }

    public int getLastShownOwnListSubCategoryTabIndex() {
        if (null != this.options) {
            return this.options.getLastShownOwnListSubCategoryTabIndex();
        }
        return new Options(this.vocabularyTrainerVersion).getLastShownOwnListSubCategoryTabIndex();
    }

    public int getNumberOfVocabularyBarColumns() {
        if (null != this.options) {
            return this.options.getNumberOfVocabularyBarColumns();
        }
        return new Options(this.vocabularyTrainerVersion).getNumberOfVocabularyBarColumns();
    }

    public TranslationDirection getTranslationDirection() {
        if (null != this.options) {
            return this.options.getTranslationDirection();
        }
        return new Options(this.vocabularyTrainerVersion).getTranslationDirection();
    }

    public int getNumberOfDaysForAWhile() {
        if (null != this.options) {
            return this.options.getNumberOfDaysForAWhile();
        }
        return new Options(this.vocabularyTrainerVersion).getNumberOfDaysForAWhile();
    }

    public int getNumberOfDaysAVocableIsNew() {
        if (null != this.options) {
            return this.options.getNumberOfDaysAVocableIsNew();
        }
        return new Options(this.vocabularyTrainerVersion).getNumberOfDaysAVocableIsNew();
    }

    public void run() {
        if (this.isInitialDirectoryChoosingNecessary()) {
            this.initialDirectoryChoosing();
        }
        this.startUp();
        if (!this.startUpErrorOccured) {
            this.perhapsShowNews();
            this.actualizeStringSelectionSize();
            this.actualizeStringSelectionLabelSize();
            this.initGuiWithVocabulariesAndOwnLists();
            this.showLoadUpMessageInStatusBar();
            this.gui.setVisible(true);
            this.checksForNewVersionsAtStart();
        }
    }

    private boolean isInitialDirectoryChoosingNecessary() {
        String string = this.options.getVocabulariesPath();
        return string.isBlank() || !FileHelper.isDirectory(string);
    }

    private void initialDirectoryChoosing() {
        String string = SystemTools.getHomeDirectory();
        String string2 = GuiTools.openDirectory(string, "Bitte das Verzeichnis mit den Vokabeln w\u00e4hlen", this.gui.getWindowAsComponent());
        if (FileHelper.isDirectory(string2)) {
            this.options.setVocabulariesPath(string2);
        } else {
            System.exit(1);
        }
    }

    private void startUp() {
        this.startUpErrorOccured = false;
        this.reallyStartUp();
    }

    private void reallyStartUp() {
        try {
            this.tryStartUp();
        }
        catch (Exception exception) {
            this.reallyQuit();
            this.gui.createErrorHandler().error("Es trat ein Fehler beim Startup auf", exception);
            this.startUpErrorOccured = true;
        }
    }

    private void tryStartUp() {
        StartupLoader startupLoader = new StartupLoader(this.gui, this.options);
        startupLoader.load();
        this.vocabularies = startupLoader.getVocabularies();
        this.internalDataRequester = startupLoader.getInternalDataRequester();
        this.loadUpMessage = startupLoader.getLoadUpMessage();
        this.japaneseToGermanTranslation = startupLoader.getJapaneseToGermanTranslation();
        this.germanToJapaneseTranslation = startupLoader.getGermanToJapaneseTranslation();
        this.ownLists = startupLoader.getOwnLists();
        this.wrongTestedVocables = startupLoader.getWrongTestedVocables();
        this.internalKanjiDataRequester = startupLoader.getInternalKanjiDataRequester();
        this.kanjiSets = startupLoader.getKanjiSets();
        this.internalKanaDataRequester = startupLoader.getInternalKanaDataRequester();
        this.startUpLog = startupLoader.getStartUpLog();
    }

    private void showLoadUpMessageInStatusBar() {
        this.gui.setMessageLater(this.loadUpMessage);
    }

    private void perhapsShowNews() {
        NewsHelper newsHelper = new NewsHelper(this.vocabularyTrainerVersion, this.options.getLastUsedVersion(), this.gui.getChanges(), this.gui.getProgramImage(), this.gui.getLocation());
        newsHelper.perhapsShowNews();
    }

    private void actualizeStringSelectionSize() {
        int n = this.options.getStringSelectionFontSize();
        if (n > -1) {
            this.gui.setStringSelectionFontSize(n);
        }
    }

    private void actualizeStringSelectionLabelSize() {
        int n = this.options.getStringSelectionLabelFontSize();
        if (n > -1) {
            this.gui.setStringSelectionLabelFontSize(n);
        }
    }

    private void initGuiWithVocabulariesAndOwnLists() {
        this.gui.initGuiWithVocabulariesAndOwnLists(this.vocabularies, this.ownLists, this.wrongTestedVocables);
    }

    public InternalDataRequester getInternalDataRequester() {
        return this.internalDataRequester;
    }

    @Override
    public void quit() {
        if (GuiTools.askUserToQuit(this.gui.getWindowAsComponent())) {
            this.reallyQuit();
        }
    }

    public void reallyQuit() {
        this.saveOptions();
        if (null != this.kanjiSets) {
            this.saveKanjiSets();
        }
        if (null != this.gui) {
            this.gui.saveManualVocabularyOrder();
            this.gui.quit();
        }
    }

    public void saveKanjiSets() {
        AllKanjiSetsWriter.write(this.kanjiSets);
    }

    public List<KanjiSet> getKanjiSets() {
        return this.kanjiSets;
    }

    public List<Vocable> collectVocablesOfAllVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    public void setVocabularySortOrder(VocabularySortOrder vocabularySortOrder) {
        this.options.setVocabularySortOrder(vocabularySortOrder);
        this.saveOptions();
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public void saveAsList(List<Vocable> list, String string) {
        this.ownLists.saveAsList(list, string);
    }

    public boolean doWeHaveToCreateGermanJapaneseTranslation() {
        return this.germanToJapaneseTranslation == null;
    }

    public void createGermanJapaneseTranslation(Runnable runnable) {
        this.gui.startLongTimeProcess("Erzeuge Datenstrukturen f\u00fcr die Zuordnung von Kana und Kanji zu Vokabeln sowie mehrdeutige Zuordnungen von Kana ohne Kanji zu Vokabeln f\u00fcr die \u00dcbersetzung von Japanisch in Deutsch");
        new Thread(() -> this.createGermanJapaneseTranslationInThread(runnable)).start();
    }

    private void createGermanJapaneseTranslationInThread(Runnable runnable) {
        this.germanToJapaneseTranslation = new GermanToJapaneseTranslation(this.vocabularies);
        SwingUtilities.invokeLater(() -> this.afterCreationGermanJapaneseTranslationInEdt(runnable));
    }

    private void afterCreationGermanJapaneseTranslationInEdt(Runnable runnable) {
        this.gui.endLongTimeProcess();
        runnable.run();
    }

    public List<Vocable> getMatchingVocablesForGermanTerm(String string) {
        if (null == this.germanToJapaneseTranslation) {
            throw new RuntimeException("Da ging etwas mit der 'lazy initialization' von germanToJapaneseTranslation schief.");
        }
        return this.germanToJapaneseTranslation.getMatchingVocablesForGermanTerm(string);
    }

    public List<Vocable> getMatchingVocablesForKana(String string) {
        return this.japaneseToGermanTranslation.getMatchingVocablesForKana(string);
    }

    public List<Vocable> getMatchingVocablesForKanaAndKanji(String string, String string2) {
        return this.japaneseToGermanTranslation.getMatchingVocablesForKanaAndKanji(string, string2);
    }

    private void checksForNewVersionsAtStart() {
        this.checkingNewVersionsOnStartUp = true;
        if (this.options.isCheckNewOwnListsVersionAtStart()) {
            this.checkNewOwnListsVersion();
        } else {
            OwnListVersionsAndInterestUpdater.updateOwnListVersionsAndInterestsForNewOwnLists();
        }
        this.checkingNewVersionsOnStartUp = false;
    }

    public void checkNewProgramVersion() {
        this.gui.startLongTimeProcess("Pr\u00fcfe auf aktuellere Programmversion");
        new Thread(() -> this.checkNewProgramVersionInOwnThread()).start();
    }

    private void checkNewProgramVersionInOwnThread() {
        String string = VocabularyTrainerVersion.getOnlyVersion();
        ProgramUpdatableChecker programUpdatableChecker = new ProgramUpdatableChecker(string, this.gui.getWindowAsComponent(), this.gui.getLocation(), this.gui.getProgramImage());
        programUpdatableChecker.update();
        SwingUtilities.invokeLater(() -> this.gui.endLongTimeProcess());
    }

    public void checkNewVocabulariesVersion() {
        this.gui.startLongTimeProcess("Pr\u00fcfe auf aktuellere Version der Vokabeln");
        new Thread(() -> this.checkNewVocabulariesVersionInOwnThread()).start();
    }

    private void checkNewVocabulariesVersionInOwnThread() {
        VocablesUpdatableChecker vocablesUpdatableChecker = new VocablesUpdatableChecker(this.options.getVocabulariesPath(), this.gui);
        vocablesUpdatableChecker.check();
        SwingUtilities.invokeLater(() -> this.gui.endLongTimeProcess());
    }

    public void checkNewOwnListsVersion() {
        VocablesActualityChecker vocablesActualityChecker = new VocablesActualityChecker(this.options.getVocabulariesPath());
        vocablesActualityChecker.check();
        if (vocablesActualityChecker.isVersionOnWebserverDetermined() && vocablesActualityChecker.isActual()) {
            this.reallyCheckNewOwnListsVersion();
        } else {
            this.informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver("Updatepr\u00fcfung der eigenen Listen");
        }
    }

    private void informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver(String string) {
        String string2 = string + ": Neuere Vokabeln auf dem Webserver!";
        String string3 = string + " entf\u00e4llt, denn es gibt neuere Vokabeln auf dem Webserver!\n\nSolange es neuere Vokabeln gibt, macht der Downonload der Gruppen von\neigenen Listen keinen Sinn, denn wenn die Vokabeln nicht aktuell sind,\ndann werden dort sofort wieder Eintr\u00e4ge entfernt.\n\nBitte aktualisieren Sie zun\u00e4chst die Vokabeln.";
        GuiTools.informUser(this.gui.getWindowAsComponent(), string2, string3);
    }

    private void reallyCheckNewOwnListsVersion() {
        OwnListGroupsUpdater ownListGroupsUpdater = new OwnListGroupsUpdater(this, this.gui, this.checkingNewVersionsOnStartUp);
        ownListGroupsUpdater.update();
    }

    public String getStartUpLog() {
        return this.startUpLog;
    }

    public void addVocableToWrongTestedVocablesList(Vocable vocable) {
        this.wrongTestedVocables.addVocableToWrongTestedVocablesList(vocable);
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
        this.gui.showTranslationDirectionOnBarButtons();
    }

    public void removeVocableFromWrongTestedVocablesList(Vocable vocable) {
        this.wrongTestedVocables.removeVocableFromWrongTestedVocablesList(vocable);
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
        this.gui.showTranslationDirectionOnBarButtons();
    }

    public void importGroupsOfOwnListsFromWebsite() {
        VocablesActualityChecker vocablesActualityChecker = new VocablesActualityChecker(this.options.getVocabulariesPath());
        vocablesActualityChecker.check();
        if (vocablesActualityChecker.isVersionOnWebserverDetermined() && vocablesActualityChecker.isActual()) {
            new Thread(() -> this.importGroupsOfOwnListsFromWebsiteInOwnThread()).start();
        } else {
            this.informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver("Import von eigenen Listen");
        }
    }

    private void importGroupsOfOwnListsFromWebsiteInOwnThread() {
        GroupsOfOwnListsFromWebsiteImporter groupsOfOwnListsFromWebsiteImporter = new GroupsOfOwnListsFromWebsiteImporter(this, this.gui);
        groupsOfOwnListsFromWebsiteImporter.importGroups();
    }

    public OwnLists getOwnLists() {
        return this.ownLists;
    }

    public InternalKanjiDataRequester getInternalKanjiDataRequester() {
        return this.internalKanjiDataRequester;
    }

    public RealInternalKanaDataRequester getInternalKanaDataRequester() {
        return this.internalKanaDataRequester;
    }

    public List<Vocable> createListOfVerbsInWoerterbuchform() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isVerbInWoerterbuchform()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfAdjectivesInPositivePresence() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isAdjectivInPositivePresence()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithOnLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!kanji.getOnLesungen().contains(string)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithKunLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!kanji.getKunLesungen().contains(string)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithAnyLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!kanji.getOnLesungen().contains(string) && !kanji.getKunLesungen().contains(string)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithGermanMeaning(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!kanji.getGermanMeaning().contains(string)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }
}

