/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.sort;

import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.sort.VocableRelevanceWeightingCalculator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VocableSorter {
    private final List<Vocable> vocables;
    private final String search;
    private Map<Vocable, Integer> relevanceWeighting;

    public VocableSorter(List<Vocable> list, String string) {
        this.vocables = list;
        this.search = string;
    }

    public void sort() {
        if (this.vocables.size() > 1 && !this.search.isBlank()) {
            this.reallySort();
        }
    }

    private void reallySort() {
        this.createRelevanceWeighting();
        this.sortByRelevanceWeighting();
    }

    private void createRelevanceWeighting() {
        this.relevanceWeighting = new HashMap<Vocable, Integer>();
        for (Vocable vocable : this.vocables) {
            int n = this.calculateRelevanceWeighting(vocable);
            this.relevanceWeighting.put(vocable, n);
        }
    }

    private int calculateRelevanceWeighting(Vocable vocable) {
        VocableRelevanceWeightingCalculator vocableRelevanceWeightingCalculator = new VocableRelevanceWeightingCalculator(vocable, this.search);
        vocableRelevanceWeightingCalculator.calculate();
        return vocableRelevanceWeightingCalculator.getWeighting();
    }

    private void sortByRelevanceWeighting() {
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                int n = VocableSorter.this.relevanceWeighting.get(vocable);
                int n2 = VocableSorter.this.relevanceWeighting.get(vocable2);
                return n - n2;
            }
        });
    }
}

