/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.success;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import java.awt.Color;
import java.util.List;

public class KatakanaListTestSuccesssCalculator {
    private final List<Katakana> katakanaList;
    private final Options options;
    private final InternalKanaDataRequester requester;
    private int lastCountSum;
    private int lastCorrectCountSum;
    private Color foregroundColor;
    private String percentText;
    private double percent;
    private String percentTextWithTwoDigitsAfterComma;

    public KatakanaListTestSuccesssCalculator(List<Katakana> list, Options options, InternalKanaDataRequester internalKanaDataRequester) {
        this.katakanaList = list;
        this.options = options;
        this.requester = internalKanaDataRequester;
    }

    public void calculate() {
        this.calculateCounts();
        this.foregroundColor = this.determineForegroundColor();
        this.determinePercentAndPercentText();
    }

    private void calculateCounts() {
        this.lastCountSum = 0;
        this.lastCorrectCountSum = 0;
        for (Katakana katakana : this.katakanaList) {
            this.calculateCountsForKatakana(katakana);
        }
    }

    private void calculateCountsForKatakana(Katakana katakana) {
        InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForKatakana(katakana);
        int n = internalAdditionalKanaData.getLastTenTestsCount();
        int n2 = internalAdditionalKanaData.getLastCorrectTestsCount();
        this.lastCountSum += n;
        this.lastCorrectCountSum += n2;
        if (n == 0) {
            this.lastCountSum += 10;
        }
    }

    private Color determineForegroundColor() {
        if (this.options.isColorVocabularyDependingOnLastSuccess()) {
            VocableColors vocableColors = new VocableColors(this.options);
            return vocableColors.determineForegroundColor(this.lastCountSum, this.lastCorrectCountSum);
        }
        return Color.BLACK;
    }

    private void determinePercentAndPercentText() {
        this.percentTextWithTwoDigitsAfterComma = NumberString.percent(this.lastCorrectCountSum, this.lastCountSum);
        this.percent = NumberString.percentAsNumber(this.lastCorrectCountSum, this.lastCountSum);
        String string = String.format("%.0f", this.percent);
        this.percentText = Text.fillWithSpacesAtFront(string, 3);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public String getPercentText() {
        return this.percentText;
    }

    public String getPercentTextWithTwoDigitsAfterComma() {
        return this.percentTextWithTwoDigitsAfterComma;
    }

    public double getPercent() {
        return this.percent;
    }
}

