/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.success;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import java.awt.Color;
import java.util.List;

public class VocabularyTestSuccesssCalculator {
    private final List<Vocable> vocables;
    private final Options options;
    private final InternalDataRequester requester;
    private int lastCountSum;
    private int lastCorrectCountSum;
    private Color foregroundColor;
    private String percentText;
    private double percent;
    private String percentTextWithTwoDigitsAfterComma;

    public VocabularyTestSuccesssCalculator(Vocabulary vocabulary, Options options, InternalDataRequester internalDataRequester) {
        this(vocabulary.getVocables(), options, internalDataRequester);
    }

    public VocabularyTestSuccesssCalculator(List<Vocable> list, Options options, InternalDataRequester internalDataRequester) {
        this.vocables = list;
        this.options = options;
        this.requester = internalDataRequester;
    }

    public void calculate() {
        this.calculateCounts();
        this.foregroundColor = this.determineForegroundColor();
        this.determinePercentAndPercentText();
    }

    private void calculateCounts() {
        this.lastCountSum = 0;
        this.lastCorrectCountSum = 0;
        for (Vocable vocable : this.vocables) {
            this.calculateCountsForVocable(vocable);
        }
    }

    private void calculateCountsForVocable(Vocable vocable) {
        int n;
        int n2;
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            n2 = internalAdditionalVocableData.getLastTenJapaneseToGermanTestsCount();
            n = internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestsCount();
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            n2 = internalAdditionalVocableData.getLastGermanToJapaneseTestsCount();
            n = internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestsCount();
        } else {
            throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
        }
        this.lastCountSum += n2;
        this.lastCorrectCountSum += n;
        if (n2 == 0) {
            this.lastCountSum += 10;
        }
    }

    private Color determineForegroundColor() {
        if (this.options.isColorVocabularyDependingOnLastSuccess()) {
            VocableColors vocableColors = new VocableColors(this.options);
            return vocableColors.determineForegroundColor(this.lastCountSum, this.lastCorrectCountSum);
        }
        return Color.BLACK;
    }

    private void determinePercentAndPercentText() {
        this.percentTextWithTwoDigitsAfterComma = NumberString.percent(this.lastCorrectCountSum, this.lastCountSum);
        this.percent = NumberString.percentAsNumber(this.lastCorrectCountSum, this.lastCountSum);
        String string = String.format("%.0f", this.percent);
        this.percentText = Text.fillWithSpacesAtFront(string, 3);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public String getPercentText() {
        return this.percentText;
    }

    public String getPercentTextWithTwoDigitsAfterComma() {
        return this.percentTextWithTwoDigitsAfterComma;
    }

    public double getPercent() {
        return this.percent;
    }
}

