/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.test;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.EmptyTranslationsAcceptance;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.test.UserAnswerCorrectnessChecker;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.testing.VocableListTesterDialog;
import java.util.List;

public class VocableListTesterLogic {
    private static final long MAX_TIME_IN_SECONDS_TO_ACCEPT_EMPTY_TRANSLATION_AFTER_LAST_TRANSLATION = 3L;
    private final VocabularyTrainerLogic logic;
    private final Options options;
    private final InternalDataRequester requester;
    private final MessageSetter messageSetter;
    private VocableListTesterDialog gui;
    private String kana;
    private String kanji;
    private String germanTerm;
    private String translationByUser;
    private List<Vocable> matchingVocables;
    private DateAndTime lastTranslationMoment;

    public VocableListTesterLogic(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, List<Vocable> list, String string, MessageSetter messageSetter) {
        this.logic = vocabularyTrainerLogic;
        this.options = vocabularyTrainerLogic.getOptions();
        this.requester = vocabularyTrainerLogic.getInternalDataRequester();
        this.messageSetter = messageSetter;
        this.lastTranslationMoment = new DateAndTime();
        if (this.options.getTranslationDirection() == TranslationDirection.GERMAN_TO_JAPANESE && !this.options.isCreateGermanJapaneseTranslationAtStartup() && vocabularyTrainerLogic.doWeHaveToCreateGermanJapaneseTranslation()) {
            vocabularyTrainerLogic.createGermanJapaneseTranslation(() -> this.createGui(vocabularyTrainerGui, list, string));
        } else {
            this.createGui(vocabularyTrainerGui, list, string);
        }
    }

    private void createGui(VocabularyTrainerGui vocabularyTrainerGui, List<Vocable> list, String string) {
        this.gui = new VocableListTesterDialog(list, string, this.options, this.requester, this, this.logic.getOwnLists(), this.logic.getInternalKanjiDataRequester(), this.messageSetter, vocabularyTrainerGui.getLocation(), vocabularyTrainerGui.getProgramImage());
        this.gui.setVisible(true);
    }

    public void test() {
    }

    public void userEnteredJapaneseToGermanTranslation(String string, String string2, String string3) {
        this.kana = string;
        this.kanji = string2;
        this.germanTerm = "";
        this.translationByUser = string3;
        this.matchingVocables = this.createMatchingVocablesForJapaneseToGerman();
        this.userEnteredTranslation();
    }

    private List<Vocable> createMatchingVocablesForJapaneseToGerman() {
        if (this.kanji.isEmpty()) {
            return this.logic.getMatchingVocablesForKana(this.kana);
        }
        return this.logic.getMatchingVocablesForKanaAndKanji(this.kana, this.kanji);
    }

    public void userEnteredGermanToJapaneseTranslation(String string, String string2) {
        this.kana = "";
        this.kanji = "";
        this.germanTerm = string;
        this.translationByUser = string2;
        this.matchingVocables = this.createMatchingVocablesForGermanToJapanese();
        this.userEnteredTranslation();
    }

    private List<Vocable> createMatchingVocablesForGermanToJapanese() {
        return this.logic.getMatchingVocablesForGermanTerm(this.germanTerm);
    }

    private void userEnteredTranslation() {
        this.gui.increaseNumberOfDoneVocables();
        UserAnswerCorrectnessChecker userAnswerCorrectnessChecker = new UserAnswerCorrectnessChecker(this.options, this.translationByUser, this.matchingVocables);
        userAnswerCorrectnessChecker.check();
        boolean bl = userAnswerCorrectnessChecker.isCorrect();
        Vocable vocable = userAnswerCorrectnessChecker.getCorrectVocable();
        if (bl) {
            this.gui.increaseNumberOfCorrectDoneVocables();
        }
        this.gui.setNumbersAndPercent();
        boolean bl2 = this.gui.informAboutTranslationSuccess(this.matchingVocables, bl, vocable);
        if (!bl && bl2) {
            this.gui.increaseNumberOfCorrectDoneVocables();
            this.gui.setNumbersAndPercent();
            vocable = this.matchingVocables.size() == 1 ? this.matchingVocables.get(0) : this.gui.letUserSelectMatchingVocableForHisTranslation(this.translationByUser, this.matchingVocables);
            bl = true;
        }
        this.saveUserTestAnswerInInternalData(this.matchingVocables, bl, vocable);
        this.lastTranslationMoment = new DateAndTime();
        if (this.options.isSwitchToNextVocableAfterEntringTranslation()) {
            this.gui.switchToNextVocable();
        }
    }

    private void saveUserTestAnswerInInternalData(List<Vocable> list, boolean bl, Vocable vocable) {
        if (bl) {
            InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
            this.tested(internalAdditionalVocableData, bl);
            int n = this.getLastCorrectTestsCount(vocable);
            if (n >= 10) {
                this.logic.removeVocableFromWrongTestedVocablesList(vocable);
            }
        } else {
            for (Vocable vocable2 : list) {
                InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable2);
                this.tested(internalAdditionalVocableData, bl);
                this.logic.addVocableToWrongTestedVocablesList(vocable2);
            }
        }
    }

    private void tested(InternalAdditionalVocableData internalAdditionalVocableData, boolean bl) {
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            internalAdditionalVocableData.testedJapaneseToGerman(bl);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            internalAdditionalVocableData.testedGermanToJapanese(bl);
        } else {
            throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
        }
    }

    private int getLastCorrectTestsCount(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestsCount();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestsCount();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    public boolean doWeHaveToReactOnEmptyTranslation() {
        EmptyTranslationsAcceptance emptyTranslationsAcceptance = this.options.getEmptyTranslationsAcceptance();
        switch (emptyTranslationsAcceptance) {
            case ALWAYS: {
                return true;
            }
            case NOT_IMMEDIATELY: {
                DateAndTime dateAndTime = new DateAndTime();
                long l = this.lastTranslationMoment.difference(dateAndTime);
                return l > 3L;
            }
            case NEVER: {
                return false;
            }
        }
        throw new RuntimeException("Unbekannte Art auf eine leere \u00dcbersetzung zu reagieren: '" + emptyTranslationsAcceptance.getOptionDescription() + "'");
    }
}

