/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.io.VocabularyDirectoryReader;
import de.duehl.vocabulary.japanese.startup.ui.MessageAppender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VocabularyAndSoundFileFinder {
    private static final boolean INFORM_ABOUT_EACH_VOCABULARY_SOUND_FILE_CREATION = false;
    private static final int MAXIMUM_NON_FATAL_ERRORS_TO_SHOW = 10;
    private static final int MAXIMUM_FATAL_ERRORS_TO_SHOW = 25;
    private final Options options;
    private final MessageAppender appender;
    private final String directory;
    private List<Vocabulary> vocabularies;
    private String loadUpMessage;
    private Map<String, String> bareFilename2FilenameMap;
    private List<String> doubleVocablesKanaTransltionMessages;
    private List<String> doubleVocablesKanaKanjiMessages;
    private List<String> vocablesWithEqualKanaAndKanjiMessages;
    private List<String> missingMp3BareFilesMessages;
    private List<String> missingMp3FilesMessages;
    private List<String> doubleMp3BareFilenamesMessages;
    private List<String> fatalErrorLines;

    public VocabularyAndSoundFileFinder(Options options, MessageAppender messageAppender) {
        this.options = options;
        this.appender = messageAppender;
        this.directory = options.getVocabulariesPath();
        this.fatalErrorLines = new ArrayList<String>();
        this.fatalErrorLines.add("Fatale Fehlermeldungen:");
        this.fatalErrorLines.add("");
    }

    public void find() {
        this.readVocabularies();
        this.createAndAppendLoadUpMessage();
        this.storeVocabularyDescriptionIntoVocable();
        this.removeVocablesWithoutKanaOrTranslation();
        this.checkIfSomeVocablesCombinationsAreUnique();
        this.determineAllSoundFiles();
        this.adjustMp3InAllVocables();
    }

    private void readVocabularies() {
        VocabularyDirectoryReader vocabularyDirectoryReader = new VocabularyDirectoryReader(this.directory);
        vocabularyDirectoryReader.read();
        this.vocabularies = vocabularyDirectoryReader.getVocabularies();
    }

    private void createAndAppendLoadUpMessage() {
        int n = 0;
        for (Vocabulary vocabulary : this.vocabularies) {
            n += vocabulary.getVocables().size();
        }
        this.loadUpMessage = "Es wurden " + NumberString.taupu(this.vocabularies.size()) + " Vokabulare mit zusammen " + NumberString.taupu(n) + " Vokabeln eingelesen.";
        this.appendMessage(this.loadUpMessage);
    }

    private void storeVocabularyDescriptionIntoVocable() {
        for (Vocabulary vocabulary : this.vocabularies) {
            String string = vocabulary.getDescription();
            for (Vocable vocable : vocabulary.getVocables()) {
                vocable.setVocabularyDescription(string);
            }
        }
    }

    private void removeVocablesWithoutKanaOrTranslation() {
        for (Vocabulary vocabulary : this.vocabularies) {
            this.removeVocablesWithoutKanaOrTranslation(vocabulary);
        }
    }

    private void removeVocablesWithoutKanaOrTranslation(Vocabulary vocabulary) {
        List<Vocable> list = vocabulary.getVocables();
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : list) {
            if (!this.shouldBeRemoved(vocable)) continue;
            arrayList.add(vocable);
        }
        if (!arrayList.isEmpty()) {
            this.appendMessage(vocabulary.getDescription() + ": Die folgenden Variablen werden entfernt, weil sie nicht vollst\u00e4ndig genug sind:");
            for (Vocable vocable : arrayList) {
                this.appendMessage(vocable.toNiceString(4));
                this.appendMessage("");
                list.remove(vocable);
            }
        }
    }

    private void appendMessage(String string) {
        this.appender.appendMessage(string);
    }

    private boolean shouldBeRemoved(Vocable vocable) {
        return vocable.getKana().isBlank() || vocable.getTranslations().isEmpty() || vocable.getTranslations().get(0).isBlank();
    }

    private void checkIfSomeVocablesCombinationsAreUnique() {
        this.doubleVocablesKanaTransltionMessages = new ArrayList<String>();
        this.doubleVocablesKanaKanjiMessages = new ArrayList<String>();
        this.vocablesWithEqualKanaAndKanjiMessages = new ArrayList<String>();
        List<Vocable> list = this.createAllVocablesList();
        for (int i = 0; i < list.size() - 1; ++i) {
            Vocable vocable = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                Vocable vocable2 = list.get(j);
                this.checkIfVocablesAreUniqueWithKeyFromKanaAndFirstTranslations(vocable, vocable2);
                this.checkIfVocablesAreUniqueWithKanjiAndKana(vocable, vocable2);
            }
        }
        for (Vocable vocable : list) {
            this.checkIfVocableHasEqualKanaAndKanji(vocable);
        }
        if (!this.doubleVocablesKanaTransltionMessages.isEmpty() && !this.doubleVocablesKanaKanjiMessages.isEmpty()) {
            this.reportAboutFatalErrorsWithoutExit("Es gibt Vokabeln, welche nach Kana und der ersten \u00dcbersetzung gleich sind:", this.doubleVocablesKanaTransltionMessages);
            this.reportAboutFatalErrorsAndExit("Es gibt Vokabeln, welche nach Kana und Kanji gleich sind:", this.doubleVocablesKanaKanjiMessages);
        }
        if (!this.doubleVocablesKanaTransltionMessages.isEmpty()) {
            this.reportAboutFatalErrorsAndExit("Es gibt Vokabeln, welche nach Kana und der ersten \u00dcbersetzung gleich sind:", this.doubleVocablesKanaTransltionMessages);
        }
        if (!this.doubleVocablesKanaKanjiMessages.isEmpty()) {
            this.reportAboutFatalErrorsAndExit("Es gibt Vokabeln, welche nach Kana und Kanji gleich sind:", this.doubleVocablesKanaKanjiMessages);
        }
        if (this.options.isInformAboutEqualKanaAndKanjiAtStartup() && !this.vocablesWithEqualKanaAndKanjiMessages.isEmpty()) {
            this.reportAboutFatalErrorsAndExit("Es gibt Vokabeln, welche identische Inhalte von Kana und Kanji haben:", this.vocablesWithEqualKanaAndKanjiMessages);
        }
    }

    private List<Vocable> createAllVocablesList() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    private void checkIfVocablesAreUniqueWithKeyFromKanaAndFirstTranslations(Vocable vocable, Vocable vocable2) {
        String string = vocable.getKana();
        String string2 = vocable2.getKana();
        String string3 = vocable.getTranslations().get(0);
        String string4 = vocable2.getTranslations().get(0);
        if (string.equals(string2) && string3.equals(string4)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            stringBuilder.append("    ").append("und").append("\n");
            stringBuilder.append(vocable2.toNiceString(12)).append("\n");
            this.doubleVocablesKanaTransltionMessages.add(stringBuilder.toString());
        }
    }

    private void checkIfVocablesAreUniqueWithKanjiAndKana(Vocable vocable, Vocable vocable2) {
        String string = vocable.getKana();
        String string2 = vocable2.getKana();
        String string3 = vocable.getKanji();
        String string4 = vocable2.getKanji();
        if (string.equals(string2) && string3.equals(string4)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            stringBuilder.append("    ").append("und").append("\n");
            stringBuilder.append(vocable2.toNiceString(12)).append("\n");
            this.doubleVocablesKanaKanjiMessages.add(stringBuilder.toString());
        }
    }

    private void checkIfVocableHasEqualKanaAndKanji(Vocable vocable) {
        String string;
        String string2 = vocable.getKana();
        if (string2.equals(string = vocable.getKanji())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(vocable.toNiceString(12)).append("\n");
            this.vocablesWithEqualKanaAndKanjiMessages.add(stringBuilder.toString());
        }
    }

    private void determineAllSoundFiles() {
        this.appendMessage("Suche die Sound-Dateien zu allen Vokabeln ...");
        this.doubleMp3BareFilenamesMessages = new ArrayList<String>();
        List<String> list = FileHelper.findFilesNio2(this.directory, ".mp3");
        this.bareFilename2FilenameMap = new HashMap<String, String>();
        for (String string : list) {
            String string2 = FileHelper.getBareName(string);
            if (this.bareFilename2FilenameMap.containsKey(string2)) {
                this.doubleMp3BareFilenamesMessages.add("    Die MP3-Datei " + string2 + " ist zweimal vorhanden:\n        Datei 1: " + this.bareFilename2FilenameMap.get(string2) + "\n        Datei 2: " + string + "\n");
            }
            this.bareFilename2FilenameMap.put(string2, string);
        }
        if (!this.doubleMp3BareFilenamesMessages.isEmpty() && this.options.isInformAboutDoubleMp3AtStartup()) {
            this.reportDoubleMp3BareFilenames();
        }
    }

    private void reportDoubleMp3BareFilenames() {
        this.reportAboutFatalErrorsAndExit("Achtung, es kommen Dateinamen (ohne Pfad) von MP3-Dateien mehrfach vor:", this.doubleMp3BareFilenamesMessages);
    }

    private void adjustMp3InAllVocables() {
        this.appendMessage("Trage die gefundenen Sound-Dateien in allen Vokabeln ein ...");
        this.missingMp3BareFilesMessages = new ArrayList<String>();
        this.missingMp3FilesMessages = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                this.searchAndStoreSoundFileWithPath(vocable);
            }
        }
        if (!this.missingMp3BareFilesMessages.isEmpty()) {
            this.reportMissingMp3BareFilesAndExit();
        }
        if (!this.missingMp3FilesMessages.isEmpty()) {
            this.reportMissingMp3FilesAndExit();
        }
    }

    private void searchAndStoreSoundFileWithPath(Vocable vocable) {
        String string = vocable.getBareMp3();
        if (string.isBlank()) {
            this.missingMp3BareFilesMessages.add("    Die Sound-Datei ohne Pfad '" + string + "' ist leer.\n        vocable = " + vocable + "\n");
        } else if (this.bareFilename2FilenameMap.containsKey(string)) {
            String string2 = this.bareFilename2FilenameMap.get(string);
            vocable.setMp3(string2);
        } else {
            this.missingMp3FilesMessages.add("    Die Sound-Datei '" + string + "' wurde nicht gefunden.\n        vocable = " + vocable + "\n");
        }
    }

    private void reportMissingMp3BareFilesAndExit() {
        this.reportAboutFatalErrorsAndExit("Es gibt Vokabeln ohne eingetragenen Namen der MP3-Datei (ohne Pfad):", this.missingMp3BareFilesMessages);
    }

    private void reportMissingMp3FilesAndExit() {
        int n = this.missingMp3FilesMessages.size();
        String string = "Es gibt " + n + " Vokabeln zu denen keine MP3-Datei (mit Pfad) gefunden wurde";
        String string2 = string + ":";
        if (this.options.isAllowMissingMp3()) {
            if (this.options.isReportMissingMp3()) {
                this.reportAboutNotFatalErrors(string2, this.missingMp3FilesMessages);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(".\n\n");
            int n2 = Math.min(3, n);
            boolean bl = n2 < n;
            for (int i = 0; i < n2; ++i) {
                if (n2 > 1) {
                    stringBuilder.append(i + 1 + ")");
                }
                stringBuilder.append(this.missingMp3FilesMessages.get(i)).append("\n");
            }
            if (bl) {
                stringBuilder.append("...\n");
            }
            stringBuilder.append("\nSoll trrotzdem gestartet werden?\nDann wird auch die Option, dass trotz fehlender MP3-Dateien gestartet wird, gesetzt.");
            String string3 = stringBuilder.toString();
            boolean bl2 = GuiTools.askUser(string, string3);
            if (bl2) {
                this.options.setAllowMissingMp3(true);
            } else {
                this.reportAboutFatalErrorsAndExit(string2, this.missingMp3FilesMessages);
            }
        }
    }

    private void reportAboutNotFatalErrors(String string, List<String> list) {
        this.appendMessage(string);
        int n = list.size();
        boolean bl = n > 10;
        int n2 = Math.min(n, 10);
        for (int i = 0; i < n2; ++i) {
            if (list.size() > 1) {
                this.appendMessage(i + 1 + ") ");
            }
            this.appendMessage(list.get(i));
        }
        if (bl) {
            this.appendMessage("... und " + NumberString.taupu(n - n2) + " weitere Fehler dieser Art.");
        }
    }

    private void reportAboutFatalErrorsAndExit(String string, List<String> list) {
        this.reportAboutFatalErrorsWithoutExit(string, list);
        this.fatalErrorLines.add("Daher wird der Start abgebrochen.");
        this.printFatalErrorMessagesToSytemErr();
        this.showFatalErrorMessagesAsDialog();
        System.exit(1);
    }

    private void reportAboutFatalErrorsWithoutExit(String string, List<String> list) {
        this.fatalErrorLines.add(string);
        int n = list.size();
        boolean bl = n > 25;
        int n2 = Math.min(n, 25);
        for (int i = 0; i < n2; ++i) {
            if (list.size() > 1) {
                this.fatalErrorLines.add(i + 1 + ") ");
            }
            this.fatalErrorLines.add(list.get(i));
        }
        if (bl) {
            this.fatalErrorLines.add("... und " + NumberString.taupu(n - n2) + " weitere Fehler dieser Art.");
        }
    }

    private void printFatalErrorMessagesToSytemErr() {
        for (String string : this.fatalErrorLines) {
            System.err.println(string);
        }
    }

    private void showFatalErrorMessagesAsDialog() {
        TextViewer textViewer = new TextViewer("Fatale Fehlermedlungen");
        textViewer.setText(Text.joinWithLineBreak(this.fatalErrorLines));
        textViewer.setVisible(true);
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public String getLoadUpMessage() {
        return this.loadUpMessage;
    }
}

