/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.ui;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.vocabulary.japanese.startup.ui.MessageAppender;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SplashScreen
extends NonModalFrameDialogBase
implements MessageAppender {
    private final StringBuilder splashTextBuilder = new StringBuilder();
    private final JTextArea textArea = new JTextArea();

    public SplashScreen(Image image) {
        super(new Point(150, 100), image, "Start des Vokabeltrainers");
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(GuiTools.createScrollPane(this.textArea), "Center");
    }

    private void initElements() {
        this.initTextArea();
    }

    private void initTextArea() {
        this.textArea.setRows(45);
        this.textArea.setColumns(120);
        this.textArea.setEditable(false);
    }

    @Override
    public void appendMessage(String string) {
        this.appendMessageToSplashTextBuilder(string);
        this.appendMessageToTextArea(string);
    }

    private void appendMessageToSplashTextBuilder(String string) {
        this.splashTextBuilder.append(string).append("\n");
    }

    private void appendMessageToTextArea(String string) {
        try {
            this.tryToAppendMessageToTextArea(string);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Kann die Nachricht [" + string + "] nicht an das Ende des Dokuments der JTextArea des SplashScreens anh\u00e4ngen.");
        }
    }

    private void tryToAppendMessageToTextArea(String string) throws BadLocationException {
        Document document = this.textArea.getDocument();
        document.insertString(document.getLength(), string + "\n", null);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public String getSplashText() {
        return this.splashTextBuilder.toString();
    }
}

