/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.button;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.view.CompleteVocabularyViewerLogic;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.VocabularySheetDialog;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OtherViewButtonPanel {
    private final List<Vocable> vocables;
    private final ViewButtonPressedReactor reactor;
    private final String description;
    private final InternalDataRequester requester;
    private final Options options;
    private final InternalKanjiDataRequester kanjiRequester;
    private final LongTimeProcessInformer informer;
    private final OwnLists ownLists;
    private final MessageSetter messageSetter;
    private final Point parentLocation;
    private final Image programImage;
    private final JPanel panel;
    private final JButton einzeldarstellungButton;
    private final JButton listenDarstellungButton;
    private final JButton blattDarstellungButton;

    public OtherViewButtonPanel(List<Vocable> list, ViewButtonPressedReactor viewButtonPressedReactor, String string, InternalDataRequester internalDataRequester, Options options, InternalKanjiDataRequester internalKanjiDataRequester, LongTimeProcessInformer longTimeProcessInformer, OwnLists ownLists, MessageSetter messageSetter, Point point, Image image) {
        this.vocables = list;
        this.reactor = viewButtonPressedReactor;
        this.description = string;
        this.requester = internalDataRequester;
        this.options = options;
        this.kanjiRequester = internalKanjiDataRequester;
        this.informer = longTimeProcessInformer;
        this.ownLists = ownLists;
        this.messageSetter = messageSetter;
        this.parentLocation = point;
        this.programImage = image;
        this.panel = new JPanel();
        this.einzeldarstellungButton = new JButton();
        this.listenDarstellungButton = new JButton();
        this.blattDarstellungButton = new JButton();
        this.createGui();
    }

    private void createGui() {
        this.initPanel();
        this.initEinzeldarstellungButton();
        this.initListenDarstellungButton();
        this.initVokabelblattDarstellungButton();
        this.fillPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new GridLayout(0, 3, 5, 5));
    }

    private void initEinzeldarstellungButton() {
        this.einzeldarstellungButton.setText("Einzeldarstellung");
        this.einzeldarstellungButton.addActionListener(actionEvent -> this.einzeldarstellung());
    }

    private void einzeldarstellung() {
        this.closeOldViewer();
        CompleteVocabularyViewerLogic completeVocabularyViewerLogic = new CompleteVocabularyViewerLogic(this.options, this.requester, this.vocables, this.kanjiRequester, this.description, this.informer, this.ownLists, this.messageSetter, this.parentLocation, this.programImage);
        completeVocabularyViewerLogic.view();
    }

    private void closeOldViewer() {
        this.reactor.otherViewOpened();
    }

    private void initListenDarstellungButton() {
        this.listenDarstellungButton.setText("Liste");
        this.listenDarstellungButton.addActionListener(actionEvent -> this.listenDarstellung());
    }

    private void listenDarstellung() {
        this.closeOldViewer();
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.options, this.requester, this.vocables, this.description, this.kanjiRequester, this.informer, this.ownLists, this.messageSetter, this.parentLocation, this.programImage);
        vocabularyListerDialog.setVisible(true);
    }

    private void initVokabelblattDarstellungButton() {
        this.blattDarstellungButton.setText("Blatt");
        this.blattDarstellungButton.addActionListener(actionEvent -> this.vokabelblattDarstellung());
    }

    private void vokabelblattDarstellung() {
        this.closeOldViewer();
        this.informer.startLongTimeProcess("\u00d6ffne Blattdarstellung mit " + this.vocables.size() + " Vokabeln");
        new Thread(() -> this.listVocabularyAsSheetInOwnThread()).start();
    }

    private void listVocabularyAsSheetInOwnThread() {
        VocabularySheetDialog vocabularySheetDialog = new VocabularySheetDialog(this.options, this.requester, this.vocables, this.description, this.kanjiRequester, this.informer, this.ownLists, this.messageSetter, this.parentLocation, this.programImage);
        this.listVocabularyAsSheetInEdt(vocabularySheetDialog);
    }

    private void listVocabularyAsSheetInEdt(VocabularySheetDialog vocabularySheetDialog) {
        vocabularySheetDialog.setVisible(true);
        vocabularySheetDialog.requestFocus();
        this.informer.endLongTimeProcess();
    }

    private void fillPanel() {
        this.panel.add(this.einzeldarstellungButton);
        this.panel.add(this.listenDarstellungButton);
        this.panel.add(this.blattDarstellungButton);
    }

    public void disableEinzeldarstellungButton() {
        this.einzeldarstellungButton.setEnabled(false);
    }

    public void disableListenDarstellungButton() {
        this.listenDarstellungButton.setEnabled(false);
    }

    public void disableVokabelblattDarstellungButton() {
        this.blattDarstellungButton.setEnabled(false);
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

