/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.display;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.TranslationCommentAndVocabularyDescriptionColorOptions;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.awt.Color;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TranslationCommentAndVocabularyDescriptionDisplay {
    private static final int COMMENT_CHARACTERS_PER_LINE = 60;
    private static final int TRANSLATION_COMMENT_CHARACTERS_PER_LINE = 45;
    private static final int FONT_SIZE_BASE = 18;
    private final Vocable vocable;
    private final JTextPane translationAndCommentPane;
    private final Color backgroundColor;
    private final TranslationCommentAndVocabularyDescriptionColorOptions options;
    private Style regularStyle;
    private Style translationStyle;
    private Style commentStyle;
    private Style searchWordsStyle;
    private Style partsOfSpeachStyle;
    private boolean showTranslations;
    private boolean showComment;
    private boolean showVocabularyDescription;
    private boolean showTranslationIntro;
    private boolean showAllTranslations;
    private int numberOfShownTranslations;

    public TranslationCommentAndVocabularyDescriptionDisplay(Vocable vocable, JTextPane jTextPane, Color color, TranslationCommentAndVocabularyDescriptionColorOptions translationCommentAndVocabularyDescriptionColorOptions) {
        this.vocable = vocable;
        this.translationAndCommentPane = jTextPane;
        this.backgroundColor = color;
        this.options = translationCommentAndVocabularyDescriptionColorOptions;
        this.showTranslations = true;
        this.showComment = true;
        this.showVocabularyDescription = true;
        this.showTranslationIntro = true;
        this.showAllTranslations = true;
        this.numberOfShownTranslations = -1;
    }

    public void hideTranslations() {
        this.showTranslations = false;
    }

    public void hideComment() {
        this.showComment = false;
    }

    public void hideVocabularyDescription() {
        this.showVocabularyDescription = false;
    }

    public void hideTranslationIntro() {
        this.showTranslationIntro = false;
    }

    public void setNumberOfShownTranslations(int n) {
        this.showAllTranslations = false;
        this.numberOfShownTranslations = n;
    }

    public void display() {
        this.initTextPane();
        this.createStyles();
        this.clearContent();
        this.fillWithNewText();
    }

    private void initTextPane() {
        this.translationAndCommentPane.setEditable(false);
        GuiTools.respectTextPaneBackgroundInNimbusLookAndFeel(this.translationAndCommentPane);
        this.translationAndCommentPane.setBackground(this.backgroundColor);
    }

    private void createStyles() {
        StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.regularStyle = styledDocument.addStyle("regular", style);
        StyleConstants.setForeground(this.regularStyle, this.options.getVocableColorStandard());
        StyleConstants.setBackground(this.regularStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.regularStyle, 18);
        StyleConstants.setSpaceAbove(this.regularStyle, 1.0f);
        StyleConstants.setSpaceBelow(this.regularStyle, 1.0f);
        StyleConstants.setLeftIndent(this.regularStyle, 16.0f);
        StyleConstants.setRightIndent(this.regularStyle, 16.0f);
        StyleConstants.setFirstLineIndent(this.regularStyle, 16.0f);
        StyleConstants.setFontFamily(this.regularStyle, "serif");
        StyleConstants.setAlignment(this.regularStyle, 0);
        this.translationStyle = styledDocument.addStyle("translation", this.regularStyle);
        StyleConstants.setForeground(this.translationStyle, this.options.getVocableColorTranslation());
        StyleConstants.setBackground(this.translationStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.translationStyle, 22);
        StyleConstants.setBold(this.translationStyle, true);
        this.commentStyle = styledDocument.addStyle("comment", this.regularStyle);
        StyleConstants.setForeground(this.commentStyle, this.options.getVocableColorComment());
        StyleConstants.setBackground(this.commentStyle, this.backgroundColor);
        this.searchWordsStyle = styledDocument.addStyle("searchWords", this.regularStyle);
        StyleConstants.setForeground(this.searchWordsStyle, this.options.getVocableColorSearchWords());
        StyleConstants.setBackground(this.searchWordsStyle, this.backgroundColor);
        this.partsOfSpeachStyle = styledDocument.addStyle("partsOfSpeach", this.regularStyle);
        StyleConstants.setForeground(this.partsOfSpeachStyle, this.options.getVocableColorPartOfSpeach());
        StyleConstants.setBackground(this.partsOfSpeachStyle, this.backgroundColor);
    }

    private void clearContent() {
        try {
            StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Probleme beim L\u00f6schen des Inhaltes des Dokument.", badLocationException);
        }
    }

    private void fillWithNewText() {
        try {
            this.tryToFillWithNewText();
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Probleme beim Einf\u00fcgen eines Stils ins Dokument.", badLocationException);
        }
    }

    private void tryToFillWithNewText() throws BadLocationException {
        if (this.showTranslations) {
            this.fillTranslations();
        }
        if (this.showComment) {
            this.fillComment();
            this.fillSearchWords();
            this.fillPartsOfSpeach();
        }
        if (this.showVocabularyDescription) {
            this.fillVocabularyDescription();
        }
    }

    private void fillTranslations() throws BadLocationException {
        List<String> list = this.vocable.getTranslations();
        if (list.size() == 1) {
            this.showOneTranslation(list.get(0));
        } else {
            this.showMultipleTranslations(list);
        }
    }

    private void showOneTranslation(String string) throws BadLocationException {
        String string2 = this.showTranslationIntro ? "\u00dcbersetzung: " : "";
        this.addTranslation(string2, string);
    }

    private void showMultipleTranslations(List<String> list) throws BadLocationException {
        StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
        if (this.showTranslationIntro) {
            styledDocument.insertString(styledDocument.getLength(), "\u00dcbersetzungen:\n", this.regularStyle);
        }
        int n = 0;
        int n2 = list.size();
        for (String string : list) {
            if (n > 0) {
                styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
            }
            String string2 = ++n + ") ";
            this.addTranslation(string2, string);
            if (this.showAllTranslations || n < this.numberOfShownTranslations) continue;
            if (n >= n2) break;
            styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
            this.addThereAreMoreTranslation(n2 - n);
            break;
        }
    }

    private void addTranslation(String string, String string2) throws BadLocationException {
        StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
        styledDocument.insertString(styledDocument.getLength(), string, this.regularStyle);
        String string3 = Text.addLineBreaks(string2, 45, string.length());
        styledDocument.insertString(styledDocument.getLength(), string3, this.translationStyle);
    }

    private void addThereAreMoreTranslation(int n) throws BadLocationException {
        String string = "... und " + n + " weitere \u00dcbersetzungen";
        StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
        styledDocument.insertString(styledDocument.getLength(), string, this.regularStyle);
    }

    private void fillComment() throws BadLocationException {
        String string = this.vocable.getComment();
        if (!string.isEmpty()) {
            string = Text.addLineBreaks(string, 60);
            string = Text.removeLineBreakAtEndIfEndsWith(string);
            StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
            styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
            styledDocument.insertString(styledDocument.getLength(), string, this.commentStyle);
        }
    }

    private void fillSearchWords() {
        List<String> list = this.vocable.getSearchWords();
        if (!list.isEmpty()) {
            String string = list.size() == 1 ? "Suchbegriff" : "Suchbegriffe";
            Object object = string + ": " + Text.joinWithCommaAndBlank(list);
            object = Text.addLineBreaks((String)object, 60);
            object = Text.removeLineBreakAtEndIfEndsWith((String)object);
            try {
                StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
                styledDocument.insertString(styledDocument.getLength(), (String)object, this.searchWordsStyle);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }
    }

    private void fillPartsOfSpeach() {
        List<String> list = this.vocable.getPartsOfSpeech();
        if (!list.isEmpty()) {
            String string = list.size() == 1 ? "Wortart" : "Wortarten";
            Object object = string + ": " + Text.joinWithCommaAndBlank(list);
            object = Text.addLineBreaks((String)object, 60);
            object = Text.removeLineBreakAtEndIfEndsWith((String)object);
            try {
                StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
                styledDocument.insertString(styledDocument.getLength(), (String)object, this.partsOfSpeachStyle);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }
    }

    private void fillVocabularyDescription() throws BadLocationException {
        String string = "(Aus dem Vokabular '" + this.vocable.getVocabularyDescription() + "')";
        StyledDocument styledDocument = this.translationAndCommentPane.getStyledDocument();
        styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
        styledDocument.insertString(styledDocument.getLength(), string, this.regularStyle);
    }
}

