/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.ui.components.VocableViewer;
import de.duehl.vocabulary.japanese.ui.components.button.OtherViewButtonPanel;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.detail.VocableWithInternaViewer;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VocabularySheetDialog
extends NonModalFrameDialogBase
implements ViewButtonPressedReactor {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 900);
    private static final int DEFAULT_NUMBER_OF_VOCABLES_IN_ONE_ROW = 3;
    private static final List<Integer> POSSIBLE_COLUMNS = CollectionsHelper.buildListFrom(1, 2, 3, 4);
    private static final int MAXIMAL_NUMBER_OF_VOCABLES_FOR_COLUMNS_CHANGE = 100;
    private final Options options;
    private final InternalDataRequester requester;
    private final List<Vocable> vocables;
    private final InternalKanjiDataRequester kanjiRequester;
    private final OwnLists ownLists;
    private final MessageSetter messageSetter;
    private final OtherViewButtonPanel otherViewPanel;
    private JScrollPane vocablesScrollPane;
    private final JPanel vocablesJPanel;
    private int numberOfColumns;
    private final JComboBox<Integer> numberOfColumnsComboBox;
    private final JButton backgroundChangingButton;

    public VocabularySheetDialog(Options options, InternalDataRequester internalDataRequester, List<Vocable> list, String string, InternalKanjiDataRequester internalKanjiDataRequester, LongTimeProcessInformer longTimeProcessInformer, OwnLists ownLists, MessageSetter messageSetter, Point point, Image image) {
        super(point, image, VocabularySheetDialog.createDialogTitle(options, internalDataRequester, list, string), DIALOG_DIMENSION);
        this.options = options;
        this.requester = internalDataRequester;
        this.kanjiRequester = internalKanjiDataRequester;
        this.ownLists = ownLists;
        this.messageSetter = messageSetter;
        this.vocablesJPanel = new JPanel();
        if (options.isUseVocablesShuffleTypeForShowingListsAndSheetsToo()) {
            VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
            VocableListShuffler vocableListShuffler = new VocableListShuffler(options, list, vocablesShuffleType, internalDataRequester);
            vocableListShuffler.shuffle();
            this.vocables = vocableListShuffler.getVocables();
        } else {
            this.vocables = list;
        }
        this.otherViewPanel = new OtherViewButtonPanel(list, this, string, internalDataRequester, options, internalKanjiDataRequester, longTimeProcessInformer, ownLists, messageSetter, point, image);
        this.otherViewPanel.disableVokabelblattDarstellungButton();
        this.numberOfColumns = options.getNumberOfColumnsOfBlattDarstellung();
        if (this.numberOfColumns < 1) {
            this.numberOfColumns = 3;
        }
        this.numberOfColumnsComboBox = new JComboBox();
        this.backgroundChangingButton = new JButton();
        this.init();
        this.rearrangeVocablePart();
        this.fillDialog();
    }

    private static String createDialogTitle(Options options, InternalDataRequester internalDataRequester, List<Vocable> list, String string) {
        String string2 = "Anzeige mit den " + NumberString.taupu(list.size()) + " Vokabeln aus " + string;
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(options, internalDataRequester, list, string2);
    }

    private void init() {
        this.initVocablesPanel();
        this.initNumberOfColumnsComboBox();
        this.initBackgroundChangingButton();
    }

    private void initVocablesPanel() {
        this.vocablesJPanel.setLayout(new BorderLayout());
    }

    private void initNumberOfColumnsComboBox() {
        this.numberOfColumnsComboBox.setAlignmentX(0.0f);
        this.numberOfColumnsComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.numberOfColumnsComboBox.getRenderer())).setHorizontalAlignment(4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(POSSIBLE_COLUMNS);
        if (!POSSIBLE_COLUMNS.contains(this.numberOfColumns)) {
            arrayList.add(this.numberOfColumns);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.numberOfColumnsComboBox.addItem(n);
        }
        this.numberOfColumnsComboBox.setSelectedItem(this.numberOfColumns);
        this.numberOfColumnsComboBox.addActionListener(actionEvent -> this.rearrangePageAfterChangedNumbers());
    }

    private void initBackgroundChangingButton() {
        this.setBackgroundChangingButtonTitle();
        this.backgroundChangingButton.addActionListener(actionEvent -> this.toggleBackground());
    }

    private void setBackgroundChangingButtonTitle() {
        String string = "Hintergrund " + (this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable() ? "aus" : "ein") + "schalten";
        this.backgroundChangingButton.setText(string);
    }

    private void toggleBackground() {
        boolean bl = this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable();
        bl = !bl;
        this.options.setColorVocableDependingOnLastSuccessWhenViewingVocable(bl);
        this.setBackgroundChangingButtonTitle();
        this.rearrangePageAfterChangedNumbers();
    }

    private void rearrangePageAfterChangedNumbers() {
        this.numberOfColumns = (Integer)this.numberOfColumnsComboBox.getSelectedItem();
        this.rearrangeVocablePart();
        this.options.setNumberOfColumnsOfBlattDarstellung(this.numberOfColumns);
    }

    private void rearrangeVocablePart() {
        List<Component> list = this.createVocablePanes();
        MultipleElementsPanel<Component> multipleElementsPanel = new MultipleElementsPanel<Component>(list, this.numberOfColumns, 1);
        this.vocablesScrollPane = GuiTools.createScrollPane(multipleElementsPanel);
        this.vocablesJPanel.removeAll();
        this.vocablesJPanel.add((Component)this.vocablesScrollPane, "Center");
        this.vocablesJPanel.repaint();
        this.vocablesJPanel.validate();
        this.vocablesJPanel.invalidate();
        GuiTools.scrollScrollbarToMinimumLater(this.vocablesScrollPane);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createUpperPart(), "North");
        this.add(this.vocablesJPanel, "Center");
        this.add(this.createButtonsPart(), "South");
    }

    private Component createUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.backgroundChangingButton, "West");
        if (this.vocables.size() <= 100) {
            jPanel.add(this.createNumberOfColumnsComboBoxWithTitelPart(), "East");
        }
        return jPanel;
    }

    private Component createNumberOfColumnsComboBoxWithTitelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Anzahl Spalten "), "West");
        jPanel.add(this.numberOfColumnsComboBox, "Center");
        return jPanel;
    }

    private List<Component> createVocablePanes() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Vocable vocable : this.vocables) {
            Component component = this.createVocablePane(vocable);
            arrayList.add(component);
        }
        return arrayList;
    }

    private Component createVocablePane(Vocable vocable) {
        VocableViewer vocableViewer = new VocableViewer(this.options);
        vocableViewer.showVocable(vocable, this.requester.getInternalDataForVocable(vocable));
        Component component = vocableViewer.getPanel();
        if (this.options.isShowDetailsButtonInVokabelblattDarstellung()) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(component, "Center");
            jPanel.add(this.createDetailsButton(vocable), "South");
            return jPanel;
        }
        return component;
    }

    private Component createDetailsButton(Vocable vocable) {
        JButton jButton = new JButton("Details anzeigen");
        jButton.addActionListener(actionEvent -> this.showDetails(vocable));
        return jButton;
    }

    private void showDetails(Vocable vocable) {
        VocableWithInternaViewer vocableWithInternaViewer = new VocableWithInternaViewer(this.options, this.requester, vocable, this.ownLists, this.kanjiRequester, this.messageSetter, this.getLocation(), this.getProgramImage());
        vocableWithInternaViewer.setVisible(true);
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        jPanel.add((Component)GuiTools.centerHorizontal(this.otherViewPanel.getPanel()), "Center");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    @Override
    public void otherViewOpened() {
        this.closeDialog();
    }
}

