/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.detail.related;

import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.RelatedVocableDeterminer;
import java.util.ArrayList;
import java.util.List;

class RelatedVocablesFinder {
    private final List<Vocabulary> vocabularies;
    private final Vocable vocable;
    private final RelatedVocableDeterminer relatedVocableDeterminer;
    private List<Vocable> relatedVocables;

    public RelatedVocablesFinder(List<Vocabulary> list, Vocable vocable, RelatedVocableDeterminer relatedVocableDeterminer) {
        this.vocabularies = list;
        this.vocable = vocable;
        this.relatedVocableDeterminer = relatedVocableDeterminer;
        if (!relatedVocableDeterminer.isRelatedVocable(vocable)) {
            throw new RuntimeException("Die Vokabel erf\u00fcllt selbst nicht die verlangte Bedingung.");
        }
    }

    public void find() {
        this.relatedVocables = new ArrayList<Vocable>();
        this.relatedVocables.add(this.vocable);
        String string = this.vocable.getKanji();
        String string2 = this.vocable.getRomaji();
        String string3 = this.vocable.getKanaInJapaneseQuotes();
        String string4 = this.vocable.getKanjiInJapaneseQuotes();
        List<Vocable> list = this.collectOtherVocables(this.vocable);
        for (Vocable vocable : list) {
            String string5 = vocable.getComment();
            boolean bl = false;
            if (string.isBlank()) {
                bl = string5.contains(string3) && string5.contains(string2);
            } else {
                boolean bl2 = bl = string5.contains(string4) && string5.contains(string3) && string5.contains(string2);
            }
            if (!bl) continue;
            this.relatedVocables.add(vocable);
        }
    }

    private List<Vocable> collectOtherVocables(Vocable vocable) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable2 : vocabulary.getVocables()) {
                if (vocable2.equals(vocable) || !this.relatedVocableDeterminer.isRelatedVocable(vocable2)) continue;
                arrayList.add(vocable2);
            }
        }
        return arrayList;
    }

    public List<Vocable> getRelatedVocables() {
        return this.relatedVocables;
    }
}

