/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.detail.related;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.AdjectivePositivePresenceFinder;
import de.duehl.vocabulary.japanese.grammar.VerbWoerterbuchformFinder;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.VerbAndAdjectiveButtonsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.VerbsAndAdjectivesFinder;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;

public class VerbsAndAdjectivesFinderGui {
    private final Vocable vocable;
    private final OwnLists ownLists;
    private final VerbsAndAdjectivesFinder verbsAndAdjectivesFinder;
    private final VerbAndAdjectiveButtonsCreator creator;

    public VerbsAndAdjectivesFinderGui(Vocable vocable, Options options, InternalDataRequester internalDataRequester, OwnLists ownLists, InternalKanjiDataRequester internalKanjiDataRequester, MessageSetter messageSetter, Point point, Image image, LongTimeProcessInformer longTimeProcessInformer) {
        this.vocable = vocable;
        this.ownLists = ownLists;
        this.verbsAndAdjectivesFinder = new VerbsAndAdjectivesFinder(options, internalDataRequester, ownLists, internalKanjiDataRequester, messageSetter, point, image, longTimeProcessInformer);
        this.creator = new VerbAndAdjectiveButtonsCreator(vocable, this.verbsAndAdjectivesFinder);
    }

    public void appendButtonsToPanel(JPanel jPanel) {
        Vocable vocable;
        if (this.vocable.isVerbInWoerterbuchform()) {
            jPanel.add(this.creator.createFindRelatedVerbsButton());
        } else if (this.vocable.isVerb()) {
            Vocable vocable2 = VerbWoerterbuchformFinder.determineWoerterbuchform(this.vocable, this.ownLists.getVocabularies());
            if (!vocable2.equals(VerbWoerterbuchformFinder.NO_WOERTERBUCHFORM_FOUND)) {
                jPanel.add(this.creator.createFindRelatedVerbsButtonViaWoerterbuchform(vocable2));
            }
        } else if (this.vocable.isAdjectivInPositivePresence()) {
            jPanel.add(this.creator.createFindRelatedAdjectiveButton());
        } else if (this.vocable.isAdjective() && !(vocable = AdjectivePositivePresenceFinder.determinePositivePresence(this.vocable, this.ownLists.getVocabularies())).equals(AdjectivePositivePresenceFinder.NO_POSITIVE_PRESENCE_FOUND)) {
            jPanel.add(this.creator.createFindRelatedAdjectiveButtonViaPositivePresence(vocable));
        }
    }
}

