/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.detail.related;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.AdjectivePositivePresenceFinder;
import de.duehl.vocabulary.japanese.grammar.VerbWoerterbuchformFinder;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.VerbAndAdjectiveButtonsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.VerbsAndAdjectivesFinder;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;

public class VerbsAndAdjectivesFinderWithChangingVocableGui {
    private final OwnLists ownLists;
    private final VerbsAndAdjectivesFinder verbsAndAdjectivesFinder;
    private final JPanel buttonPanel;

    public VerbsAndAdjectivesFinderWithChangingVocableGui(Options options, InternalDataRequester internalDataRequester, OwnLists ownLists, InternalKanjiDataRequester internalKanjiDataRequester, MessageSetter messageSetter, Point point, Image image, LongTimeProcessInformer longTimeProcessInformer) {
        this.ownLists = ownLists;
        this.verbsAndAdjectivesFinder = new VerbsAndAdjectivesFinder(options, internalDataRequester, ownLists, internalKanjiDataRequester, messageSetter, point, image, longTimeProcessInformer);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new VerticalLayout(0, 3));
    }

    public void appendButtonsToPanel(JPanel jPanel) {
        jPanel.add(this.buttonPanel);
    }

    public void setVocable(Vocable vocable) {
        this.updateButtonPanel(vocable);
    }

    private void updateButtonPanel(Vocable vocable) {
        Vocable vocable2;
        VerbAndAdjectiveButtonsCreator verbAndAdjectiveButtonsCreator = new VerbAndAdjectiveButtonsCreator(vocable, this.verbsAndAdjectivesFinder);
        this.buttonPanel.removeAll();
        if (vocable.isVerbInWoerterbuchform()) {
            this.buttonPanel.add(verbAndAdjectiveButtonsCreator.createFindRelatedVerbsButton());
        } else if (vocable.isVerb()) {
            Vocable vocable3 = VerbWoerterbuchformFinder.determineWoerterbuchform(vocable, this.ownLists.getVocabularies());
            if (!vocable3.equals(VerbWoerterbuchformFinder.NO_WOERTERBUCHFORM_FOUND)) {
                this.buttonPanel.add(verbAndAdjectiveButtonsCreator.createFindRelatedVerbsButtonViaWoerterbuchform(vocable3));
            }
        } else if (vocable.isAdjectivInPositivePresence()) {
            this.buttonPanel.add(verbAndAdjectiveButtonsCreator.createFindRelatedAdjectiveButton());
        } else if (vocable.isAdjective() && !(vocable2 = AdjectivePositivePresenceFinder.determinePositivePresence(vocable, this.ownLists.getVocabularies())).equals(AdjectivePositivePresenceFinder.NO_POSITIVE_PRESENCE_FOUND)) {
            this.buttonPanel.add(verbAndAdjectiveButtonsCreator.createFindRelatedAdjectiveButtonViaPositivePresence(vocable2));
        }
    }
}

