/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import java.awt.Color;
import javax.swing.JLabel;

public class KanjiLabel {
    private static final int DEFAULT_BIGGER_FONT_SIZE = 400;
    private int biggerFontSize = 400;
    private final JLabel label = new JLabel();
    private boolean sizeSet = false;

    public KanjiLabel() {
        this.initLabel();
    }

    private void initLabel() {
        this.label.setOpaque(true);
        this.label.setBackground(Color.WHITE);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
    }

    public void setBiggerFontSize(int n) {
        this.biggerFontSize = n;
    }

    public void showKanji(Kanji kanji) {
        this.setSizeIfNecessary();
        String string = kanji.getCharacter();
        this.label.setText(string);
    }

    private void setSizeIfNecessary() {
        if (!this.sizeSet) {
            GuiTools.biggerFont(this.label, this.biggerFontSize);
            this.sizeSet = true;
        }
    }

    public JLabel getLabel() {
        return this.label;
    }
}

