/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components.KanjiLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class KanjiPanel {
    private final KanjiLabel kanjiLabel = new KanjiLabel();
    private boolean showInternalKanjiData;
    private boolean showKanjiAsViewerToo;
    private InternalKanjiDataRequester requester;
    private final JPanel panel;
    private final StringSelection kanjiAsCharacterSeletion;
    private final StringSelection germanMeaningSelection;
    private final StringSelection onLesungenSelection;
    private final StringSelection kunLesungenSelection;
    private final StringSelection numberInKanjiAndKanaBookSelection;
    private final StringSelection pageNumberInKanjiAndKanaBookSelection;
    private final StringSelection firstSeenDateSelection;
    private final StringSelection testCountSelection;
    private final StringSelection correctTestCountSelection;
    private final StringSelection lastTestDatetSelection;
    private final StringSelection lastCorrectTestDateSelection;
    private final StringSelection lastTenTestResultsSelection;

    public KanjiPanel() {
        this.kanjiLabel.setBiggerFontSize(200);
        this.showInternalKanjiData = false;
        this.showKanjiAsViewerToo = false;
        this.panel = new JPanel();
        this.kanjiAsCharacterSeletion = new StringSelection("Das Kanji (noch einmal zum rauskopieren)");
        this.germanMeaningSelection = new StringSelection("Deutsche Bedeutung");
        this.onLesungenSelection = new StringSelection("ON-Lesungen");
        this.kunLesungenSelection = new StringSelection("kun-Lesungen");
        this.numberInKanjiAndKanaBookSelection = new StringSelection("Nummer im im Buch 'Kanji und Kana' von Wolfgang Hadamitzky");
        this.pageNumberInKanjiAndKanaBookSelection = new StringSelection("Seite im im Buch 'Kanji und Kana' von Wolfgang Hadamitzky");
        this.firstSeenDateSelection = new StringSelection("Zuerst gesehen");
        this.testCountSelection = new StringSelection("Anzahl Test");
        this.correctTestCountSelection = new StringSelection("Anzahl erfolgreicher Test");
        this.lastTestDatetSelection = new StringSelection("zuletzt getestet am");
        this.lastCorrectTestDateSelection = new StringSelection("zuletzt erfolgreich getestet am");
        this.lastTenTestResultsSelection = new StringSelection("Erfolg der letzten Tests");
        this.init();
    }

    private void init() {
        this.initAssetFocusableViewer(this.kanjiAsCharacterSeletion);
        this.initAssetFocusableViewer(this.kanjiAsCharacterSeletion);
        this.initAssetFocusableViewer(this.germanMeaningSelection);
        this.initAssetFocusableViewer(this.onLesungenSelection);
        this.initAssetFocusableViewer(this.kunLesungenSelection);
        this.initAssetFocusableViewer(this.numberInKanjiAndKanaBookSelection);
        this.initAssetFocusableViewer(this.pageNumberInKanjiAndKanaBookSelection);
        this.initAssetFocusableViewer(this.firstSeenDateSelection);
        this.initAssetFocusableViewer(this.testCountSelection);
        this.initAssetFocusableViewer(this.correctTestCountSelection);
        this.initAssetFocusableViewer(this.lastTestDatetSelection);
        this.initAssetFocusableViewer(this.lastCorrectTestDateSelection);
        this.initAssetFocusableViewer(this.lastTenTestResultsSelection);
    }

    private void initAssetFocusableViewer(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setFocusable(true);
    }

    public void showKanjiAsViewerToo() {
        this.showKanjiAsViewerToo = true;
    }

    public void showInternalKanjiDataToo(InternalKanjiDataRequester internalKanjiDataRequester) {
        this.showInternalKanjiData = true;
        this.requester = internalKanjiDataRequester;
    }

    public void createGui() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.kanjiLabel.getLabel(), "Center");
        this.panel.add(this.createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart(), "South");
    }

    private Component createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (this.showKanjiAsViewerToo) {
            jPanel.add(this.kanjiAsCharacterSeletion.getPanel());
        }
        jPanel.add(this.createGermanMeaningOnLesungenAndKunLesungenPart());
        if (this.showInternalKanjiData) {
            jPanel.add(this.createInternalKanjiDataPart());
        }
        return jPanel;
    }

    private Component createGermanMeaningOnLesungenAndKunLesungenPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.germanMeaningSelection.getPanel());
        jPanel.add(this.onLesungenSelection.getPanel());
        jPanel.add(this.kunLesungenSelection.getPanel());
        return jPanel;
    }

    private Component createInternalKanjiDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.numberInKanjiAndKanaBookSelection.getPanel());
        jPanel.add(this.pageNumberInKanjiAndKanaBookSelection.getPanel());
        jPanel.add(this.firstSeenDateSelection.getPanel());
        jPanel.add(this.testCountSelection.getPanel());
        jPanel.add(this.correctTestCountSelection.getPanel());
        jPanel.add(this.lastTestDatetSelection.getPanel());
        jPanel.add(this.lastCorrectTestDateSelection.getPanel());
        jPanel.add(this.lastTenTestResultsSelection.getPanel());
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void showKanji(Kanji kanji) {
        this.kanjiLabel.showKanji(kanji);
        this.kanjiAsCharacterSeletion.setText(kanji.getCharacter());
        this.germanMeaningSelection.setText(kanji.getGermanMeaning());
        this.onLesungenSelection.setText(Text.joinWithCommaAndBlank(kanji.getOnLesungen()));
        this.kunLesungenSelection.setText(Text.joinWithCommaAndBlank(kanji.getKunLesungen()));
        if (this.showInternalKanjiData) {
            this.numberInKanjiAndKanaBookSelection.setText(kanji.getNumberInKanjiAndKanaBook());
            this.pageNumberInKanjiAndKanaBookSelection.setText(kanji.getPageNumberInKanjiAndKanaBook());
            InternalAdditionalKanjiData internalAdditionalKanjiData = this.requester.getInternalDataForKanji(kanji);
            this.firstSeenDateSelection.setText(internalAdditionalKanjiData.getFirstSeenDate().toString());
            this.testCountSelection.setText(internalAdditionalKanjiData.getTestCount());
            this.correctTestCountSelection.setText(internalAdditionalKanjiData.getCorrectTestCount());
            this.lastTestDatetSelection.setText(internalAdditionalKanjiData.getLastTestDate().toString());
            this.lastCorrectTestDateSelection.setText(internalAdditionalKanjiData.getLastCorrectTestDate().toString());
            this.lastTenTestResultsSelection.setText(internalAdditionalKanjiData.getLastTenTestResultsAsStorageString());
        }
    }
}

